/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;

public class Defaults<A extends Annotation>
implements InvocationHandler {
    protected final Iterable<A> annotations;

    public static <A extends Annotation> A of(Class<A> annotation) {
        return (A)((Annotation)Proxy.newProxyInstance(annotation.getClassLoader(), new Class[]{annotation}, new Defaults<A>()));
    }

    public static <A extends Annotation> A of(Class<A> type, Iterable<A> annotations) {
        return (A)((Annotation)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new Defaults<A>(annotations)));
    }

    @SafeVarargs
    public static <A extends Annotation> A of(Class<A> type, A ... annotations) {
        return Defaults.of(type, Arrays.asList(annotations));
    }

    protected Defaults() {
        this.annotations = Collections.emptyList();
    }

    protected Defaults(Iterable<A> annotations) {
        this.annotations = annotations;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object defaultValue = method.getDefaultValue();
        for (Annotation each : this.annotations) {
            Object value;
            if (each == null || (value = method.invoke((Object)each, new Object[0])) == null || value.equals(defaultValue)) continue;
            return value;
        }
        return defaultValue;
    }
}

