/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.log4j.MDC;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class RandomBug
implements MethodRule {
    public static final String MODE_PROPERTY = "nuxeo.tests.random.mode";
    public static final MODE DEFAULT = MODE.RELAX;

    public Statement apply(Statement statement, FrameworkMethod method, Object target) {
        Repeat repeat = (Repeat)method.getAnnotation(Repeat.class);
        if (repeat == null) {
            repeat = target.getClass().getAnnotation(Repeat.class);
        }
        if (repeat == null) {
            return statement;
        }
        switch (RandomBug.getMode()) {
            case BYPASS: {
                return new NoopStatement(repeat.issue());
            }
            case STRICT: {
                return new RepeatOnSuccess(statement, repeat.onSuccess(), repeat.issue());
            }
            case RELAX: {
                return new RepeatOnFailure(statement, repeat.onFailure(), repeat.issue());
            }
        }
        return statement;
    }

    public static MODE getMode() {
        String mode = System.getProperty(MODE_PROPERTY, DEFAULT.name());
        return MODE.valueOf(mode.toUpperCase());
    }

    private static class NoopStatement
    extends Statement {
        private String issue;

        public NoopStatement(String issue) {
            this.issue = issue;
        }

        public void evaluate() throws Throwable {
            throw new AssumptionViolatedException("Random bug ignored (bypass mode): " + this.issue);
        }
    }

    private static class RepeatOnSuccess
    extends Statement {
        private final int times;
        private final Statement statement;
        private String issue;

        private RepeatOnSuccess(Statement statement, int times, String issue) {
            this.statement = statement;
            this.times = times;
            this.issue = issue;
        }

        public void evaluate() throws Throwable {
            AssertionError error = new AssertionError((Object)String.format("No failure after %d tries. Either the bug is fixed or you should increase the 'onSuccess' value.\nIssue: %s", this.times, this.issue));
            for (int i = 1; i <= this.times; ++i) {
                MDC.put((String)"fRepeat", (Object)i);
                try {
                    this.statement.evaluate();
                    continue;
                }
                finally {
                    MDC.remove((String)"fRepeat");
                }
            }
            throw error;
        }
    }

    private static class RepeatOnFailure
    extends Statement {
        private final int times;
        private final Statement statement;
        private String issue;

        private RepeatOnFailure(Statement statement, int times, String issue) {
            this.statement = statement;
            this.times = times;
            this.issue = issue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            AssertionError error = new AssertionError((Object)String.format("No success after %d tries. Either the bug is not random or you should increase the 'onFailure' value.\nIssue: %s", this.times, this.issue));
            for (int i = 1; i <= this.times; ++i) {
                MDC.put((String)"fRepeat", (Object)i);
                try {
                    this.statement.evaluate();
                    return;
                }
                catch (Throwable t) {
                    ((Throwable)((Object)error)).addSuppressed(t);
                    continue;
                }
                finally {
                    MDC.remove((String)"fRepeat");
                }
            }
            throw error;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface Repeat {
        public String issue();

        public int onSuccess() default 30;

        public int onFailure() default 10;
    }

    public static enum MODE {
        BYPASS,
        STRICT,
        RELAX;

    }
}

