/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.inject.Binder;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URLStreamHandlerFactoryInstaller;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.runtime.RuntimeServiceEvent;
import org.nuxeo.runtime.RuntimeServiceListener;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.test.NXRuntimeTestCase;
import org.nuxeo.runtime.test.runner.BlacklistComponent;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.DeploymentSet;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RunnerFeature;
import org.nuxeo.runtime.test.runner.RuntimeHarness;
import org.nuxeo.runtime.test.runner.ServiceProvider;
import org.nuxeo.runtime.test.runner.SimpleFeature;

@Deploy(value={"org.nuxeo.runtime.jtajca"})
public class RuntimeFeature
extends SimpleFeature {
    private static final Log log = LogFactory.getLog(RuntimeFeature.class);
    protected RuntimeHarness harness;
    protected final DeploymentSet deploy = new DeploymentSet();
    protected final Map<Class<?>, ServiceProvider<?>> serviceProviders = new HashMap();

    public <T> void addServiceProvider(ServiceProvider<T> provider) {
        this.serviceProviders.put(provider.getServiceClass(), provider);
    }

    public RuntimeHarness getHarness() {
        return this.harness;
    }

    public DeploymentSet deployments() {
        return this.deploy;
    }

    private void scanDeployments(FeaturesRunner runner) {
        List<RunnerFeature> features = runner.getFeatures();
        if (features == null) {
            throw new IllegalStateException("Cannot call scanDeployments until features are not loaded");
        }
        for (RunnerFeature feature : features) {
            this.deploy.load(FeaturesRunner.getScanner(), feature.getClass());
        }
        this.deploy.load(FeaturesRunner.getScanner(), runner.getTestClass().getJavaClass());
    }

    public String[] getDeployments() {
        return this.deploy.getDeployments().toArray(new String[this.deploy.getDeployments().size()]);
    }

    public String[] getLocalDeployments() {
        return this.deploy.getLocalDeployments().toArray(new String[this.deploy.getLocalDeployments().size()]);
    }

    protected void indexBundleResources(FeaturesRunner runner, Set<String> bundles, SetMultimap<String, String> resources, String[] directives) throws IOException {
        for (String directive : directives) {
            int sepIndex = directive.indexOf(58);
            if (sepIndex == -1) {
                bundles.add(directive);
                continue;
            }
            String bundle = directive.substring(0, sepIndex);
            String resource = directive.substring(sepIndex + 1);
            resources.put((Object)bundle, (Object)resource);
        }
    }

    protected void deployTestClassBundles(FeaturesRunner runner) throws Exception {
        HashSet<String> bundles = new HashSet<String>();
        HashMap mainDeployments = new HashMap();
        SetMultimap mainIndex = Multimaps.newSetMultimap(mainDeployments, (Supplier)new Supplier<Set<String>>(){

            public Set<String> get() {
                return new HashSet<String>();
            }
        });
        HashMap localDeployments = new HashMap();
        SetMultimap localIndex = Multimaps.newSetMultimap(localDeployments, (Supplier)new Supplier<Set<String>>(){

            public Set<String> get() {
                return new HashSet<String>();
            }
        });
        this.indexBundleResources(runner, bundles, (SetMultimap<String, String>)mainIndex, this.getDeployments());
        this.indexBundleResources(runner, bundles, (SetMultimap<String, String>)localIndex, this.getLocalDeployments());
        AssertionError errors = new AssertionError((Object)"cannot deploy components");
        for (String name : bundles) {
            BundleImpl bundle = null;
            try {
                this.harness.deployBundle(name);
                bundle = this.harness.getOSGiAdapter().getBundle(name);
            }
            catch (Exception error) {
                ((Throwable)((Object)errors)).addSuppressed(error);
                continue;
            }
            try {
                for (String resource : mainIndex.removeAll((Object)name)) {
                    try {
                        this.harness.deployContrib(name, resource);
                    }
                    catch (Exception error) {
                        ((Throwable)((Object)errors)).addSuppressed(error);
                    }
                }
                for (String resource : localIndex.removeAll((Object)name)) {
                    URL url = runner.getTargetTestResource(name);
                    if (url == null) {
                        url = bundle.getEntry(resource);
                    }
                    if (url == null) {
                        url = runner.getTargetTestClass().getClassLoader().getResource(resource);
                    }
                    if (url == null) {
                        throw new AssertionError((Object)("Cannot find " + resource + " in " + name));
                    }
                    this.harness.deployTestContrib(name, url);
                }
            }
            catch (Exception error) {
                ((Throwable)((Object)errors)).addSuppressed(error);
            }
        }
        for (Map.Entry resource : mainIndex.entries()) {
            try {
                this.harness.deployContrib((String)resource.getKey(), (String)resource.getValue());
            }
            catch (Exception error) {
                ((Throwable)((Object)errors)).addSuppressed(error);
            }
        }
        for (Map.Entry resource : localIndex.entries()) {
            try {
                this.harness.deployTestContrib((String)resource.getKey(), (String)resource.getValue());
            }
            catch (Exception error) {
                ((Throwable)((Object)errors)).addSuppressed(error);
            }
        }
        if (((Throwable)((Object)errors)).getSuppressed().length > 0) {
            throw errors;
        }
    }

    @Override
    public void initialize(FeaturesRunner runner) throws Exception {
        this.harness = new NXRuntimeTestCase(runner.getTargetTestClass());
        this.scanDeployments(runner);
    }

    @Override
    public void start(final FeaturesRunner runner) throws Exception {
        Framework.addListener((RuntimeServiceListener)new RuntimeServiceListener(){

            public void handleEvent(RuntimeServiceEvent event) {
                if (event.id != 0) {
                    return;
                }
                Framework.removeListener((RuntimeServiceListener)this);
                RuntimeFeature.this.blacklistComponents(runner);
            }
        });
        if (!this.harness.isStarted()) {
            this.harness.start();
        }
        this.deployTestClassBundles(runner);
    }

    protected void blacklistComponents(FeaturesRunner aRunner) {
        BlacklistComponent config = aRunner.getConfig(BlacklistComponent.class);
        if (config.value().length == 0) {
            return;
        }
        ComponentManager manager = Framework.getRuntime().getComponentManager();
        HashSet<String> blacklist = new HashSet<String>(manager.getBlacklist());
        blacklist.addAll(Arrays.asList(config.value()));
        manager.setBlacklist(blacklist);
    }

    @Override
    public void beforeRun(FeaturesRunner runner) throws Exception {
        this.harness.fireFrameworkStarted();
    }

    @Override
    public void stop(FeaturesRunner runner) throws Exception {
        try {
            if (this.harness.isStarted()) {
                this.harness.stop();
            }
        }
        finally {
            this.cleanupClassLoader();
        }
    }

    protected void cleanupClassLoader() {
        URLStreamHandlerFactoryInstaller.resetURLStreamHandlers();
    }

    protected void resetStaticField(Class<?> clazz, String name) {
        try {
            Field f = clazz.getDeclaredField(name);
            f.setAccessible(true);
            f.set(null, null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            log.error((Object)("Cannot reset field " + clazz.getName() + "." + name), (Throwable)e);
        }
    }

    @Override
    public void configure(FeaturesRunner runner, Binder binder) {
        for (String svc : Framework.getRuntime().getComponentManager().getServices()) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(svc);
                ServiceProvider<?> provider = this.serviceProviders.get(clazz);
                if (provider == null) {
                    provider = new ServiceProvider(clazz);
                }
                this.bind0(binder, clazz, provider);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to bind service: " + svc, e);
            }
        }
        binder.bind(RuntimeHarness.class).toInstance((Object)this.getHarness());
    }

    protected <T> void bind0(Binder binder, Class<T> type, ServiceProvider<T> provider) {
        binder.bind(type).toProvider(provider).in(provider.getScope());
    }
}

