/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test;

import java.util.List;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public class Failures {
    private static final Log log = LogFactory.getLog(Failures.class);
    private List<Failure> failures;

    public Failures(List<Failure> failures) {
        this.failures = failures;
    }

    public Failures(Result result) {
        this.failures = result.getFailures();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 1;
        AssertionFailedError errors = new AssertionFailedError();
        for (Failure failure : this.failures) {
            buffer.append("* Failure " + i + ": ").append(failure.getTestHeader()).append("\n").append(failure.getTrace()).append("\n");
            errors.addSuppressed(failure.getException());
            ++i;
        }
        if (errors.getSuppressed().length > 0) {
            log.debug((Object)errors.getMessage(), (Throwable)errors);
        }
        return buffer.toString();
    }

    public void fail(String originalMessage, String customMessage) {
        if (this.failures.isEmpty()) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 1;
        AssertionFailedError errors = new AssertionFailedError();
        for (Failure failure : this.failures) {
            buffer.append("\n* Failure " + i + ": ");
            if (originalMessage != null && originalMessage.equals(failure.getMessage())) {
                buffer.append(failure.getTestHeader() + ":" + customMessage);
            } else {
                buffer.append(String.format("Unexpected failure at %s\n%s", failure.getTestHeader(), failure.getTrace()));
                errors.addSuppressed(failure.getException());
            }
            ++i;
        }
        log.error((Object)errors.getMessage(), (Throwable)errors);
        Assert.fail((String)buffer.toString());
    }
}

