/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.MDC;
import org.junit.Ignore;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.MethodRule;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.nuxeo.runtime.test.TargetResourceLocator;
import org.nuxeo.runtime.test.runner.AnnotationScanner;
import org.nuxeo.runtime.test.runner.ConditionalIgnoreRule;
import org.nuxeo.runtime.test.runner.Defaults;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.RandomBug;
import org.nuxeo.runtime.test.runner.RunnerFeature;

public class FeaturesRunner
extends BlockJUnit4ClassRunner {
    protected static final AnnotationScanner scanner = new AnnotationScanner();
    protected Injector injector;
    protected final Set<Class<? extends RunnerFeature>> featureClasses = new LinkedHashSet<Class<? extends RunnerFeature>>();
    protected final List<RunnerFeature> features = new ArrayList<RunnerFeature>();
    protected final TargetResourceLocator locator;
    protected final ConditionalIgnoreRule ignoreRule = new ConditionalIgnoreRule();
    protected final RandomBug randomBugRule = new RandomBug();

    public static AnnotationScanner getScanner() {
        return scanner;
    }

    public static <T> List<T> reversed(List<T> list) {
        ArrayList<T> reversed = new ArrayList<T>(list);
        Collections.reverse(reversed);
        return reversed;
    }

    public FeaturesRunner(Class<?> classToRun) throws InitializationError {
        super(classToRun);
        this.locator = new TargetResourceLocator(classToRun);
        try {
            this.loadFeatures(this.getTargetTestClass());
        }
        catch (Throwable t) {
            throw new InitializationError(Collections.singletonList(t));
        }
    }

    public Class<?> getTargetTestClass() {
        return super.getTestClass().getJavaClass();
    }

    public Path getTargetTestBasepath() {
        return this.locator.getBasepath();
    }

    public URL getTargetTestResource(String name) throws IOException {
        return this.locator.getTargetTestResource(name);
    }

    protected void loadFeature(HashSet<Class<?>> cycles, Set<Class<? extends RunnerFeature>> features, Class<? extends RunnerFeature> clazz) throws Exception {
        if (features.contains(clazz)) {
            return;
        }
        if (cycles.contains(clazz)) {
            throw new IllegalStateException("Cycle detected in features dependencies of " + clazz);
        }
        cycles.add(clazz);
        scanner.scan(clazz);
        List<Features> annos = scanner.getAnnotations(clazz, Features.class);
        if (annos != null) {
            for (Features anno : annos) {
                for (Class<? extends RunnerFeature> cl : anno.value()) {
                    if (features.contains(cl)) continue;
                    this.loadFeature(cycles, features, cl);
                }
            }
        }
        features.add(clazz);
    }

    public void loadFeatures(Class<?> classToRun) throws Exception {
        scanner.scan(classToRun);
        List<Features> annos = scanner.getAnnotations(classToRun, Features.class);
        if (annos != null) {
            for (Features anno : annos) {
                for (Class<? extends RunnerFeature> cl : anno.value()) {
                    if (this.features.contains(cl)) continue;
                    this.loadFeature(new HashSet(), this.featureClasses, cl);
                }
            }
        }
    }

    public <T extends RunnerFeature> T getFeature(Class<T> type) {
        for (RunnerFeature rf : this.features) {
            if (rf.getClass() != type) continue;
            return (T)((RunnerFeature)type.cast(rf));
        }
        return null;
    }

    public List<RunnerFeature> getFeatures() {
        return this.features;
    }

    public <T extends Annotation> T getConfig(Class<T> type) {
        ArrayList<T> configs = new ArrayList<T>();
        T annotation = scanner.getAnnotation(this.getTargetTestClass(), type);
        if (annotation != null) {
            configs.add(annotation);
        }
        for (RunnerFeature feature : Lists.reverse(this.features)) {
            annotation = scanner.getAnnotation(feature.getClass(), type);
            if (annotation == null) continue;
            configs.add(annotation);
        }
        return Defaults.of(type, configs);
    }

    public <T extends Annotation> T getConfig(FrameworkMethod method, Class<T> type) {
        Annotation config = method.getAnnotation(type);
        if (config != null) {
            return (T)config;
        }
        return this.getConfig(type);
    }

    protected void initialize() throws Exception {
        this.features.clear();
        for (Class<? extends RunnerFeature> fc : this.featureClasses) {
            RunnerFeature rf = fc.newInstance();
            this.features.add(rf);
        }
        for (RunnerFeature feature : this.features) {
            feature.initialize(this);
        }
    }

    protected void beforeRun() throws Exception {
        this.invokeFeatures(this.features, new FeatureCallable(){

            @Override
            public void call(RunnerFeature feature) throws Exception {
                feature.beforeRun(FeaturesRunner.this);
            }
        });
    }

    protected void beforeMethodRun(final FrameworkMethod method, final Object test) throws Exception {
        MDC.put((String)"fMethod", (Object)method.getMethod());
        this.invokeFeatures(this.features, new FeatureCallable(){

            @Override
            public void call(RunnerFeature feature) throws Exception {
                feature.beforeMethodRun(FeaturesRunner.this, method, test);
            }
        });
        this.injector.injectMembers(test);
    }

    protected void afterMethodRun(final FrameworkMethod method, final Object test) throws Exception {
        try {
            this.invokeFeatures(this.features, new FeatureCallable(){

                @Override
                public void call(RunnerFeature feature) throws Exception {
                    feature.afterMethodRun(FeaturesRunner.this, method, test);
                }
            });
        }
        finally {
            MDC.remove((String)"fMethod");
        }
    }

    protected void afterRun() throws Exception {
        this.invokeFeatures(FeaturesRunner.reversed(this.features), new FeatureCallable(){

            @Override
            public void call(RunnerFeature feature) throws Exception {
                feature.afterRun(FeaturesRunner.this);
            }
        });
    }

    protected void testCreated(final Object test) throws Exception {
        this.invokeFeatures(this.features, new FeatureCallable(){

            @Override
            public void call(RunnerFeature feature) throws Exception {
                feature.testCreated(test);
            }
        });
    }

    protected void start() throws Exception {
        MDC.put((String)"fclass", this.getTargetTestClass());
        this.initialize();
        this.invokeFeatures(this.features, new FeatureCallable(){

            @Override
            public void call(RunnerFeature feature) throws Exception {
                feature.start(FeaturesRunner.this);
            }
        });
    }

    protected void stop() throws Exception {
        try {
            this.invokeFeatures(FeaturesRunner.reversed(this.features), new FeatureCallable(){

                @Override
                public void call(RunnerFeature feature) throws Exception {
                    feature.stop(FeaturesRunner.this);
                }
            });
        }
        finally {
            MDC.remove((String)"fclass");
        }
    }

    protected void beforeSetup() {
        this.invokeFeatures(this.features, new FeatureCallable(){

            @Override
            public void call(RunnerFeature feature) throws Exception {
                feature.beforeSetup(FeaturesRunner.this);
            }
        });
    }

    protected void afterTeardown() {
        this.invokeFeatures(FeaturesRunner.reversed(this.features), new FeatureCallable(){

            @Override
            public void call(RunnerFeature feature) throws Exception {
                feature.afterTeardown(FeaturesRunner.this);
            }
        });
    }

    protected void configureBindings(final Binder binder) {
        binder.bind(FeaturesRunner.class).toInstance((Object)this);
        binder.bind(TargetResourceLocator.class).toInstance((Object)this.locator);
        this.invokeFeatures(FeaturesRunner.reversed(this.features), new FeatureCallable(){

            @Override
            public void call(RunnerFeature feature) throws Exception {
                feature.configure(FeaturesRunner.this, binder);
            }
        });
    }

    public Injector getInjector() {
        return this.injector;
    }

    public void resetInjector() {
        this.injector = this.createInjector();
    }

    protected Injector createInjector() {
        Module module = new Module(){

            public void configure(Binder arg0) {
                FeaturesRunner.this.configureBindings(arg0);
            }
        };
        return Guice.createInjector((Module[])new Module[]{module});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        AssertionError errors = new AssertionError((Object)"features error");
        this.ignoreRule.runNotifier = notifier;
        try {
            try {
                this.start();
                try {
                    this.beforeRun();
                    this.resetInjector();
                    super.run(notifier);
                }
                catch (Exception error) {
                    ((Throwable)((Object)errors)).addSuppressed(error);
                }
                finally {
                    this.afterRun();
                }
            }
            catch (AssumptionViolatedException e) {
                notifier.fireTestIgnored(this.getDescription());
            }
            catch (Exception error) {
                ((Throwable)((Object)errors)).addSuppressed(error);
            }
            finally {
                try {
                    this.stop();
                }
                catch (Exception error) {
                    error.addSuppressed((Throwable)((Object)errors));
                }
            }
        }
        catch (Throwable error) {
            ((Throwable)((Object)errors)).addSuppressed(error);
        }
        finally {
            if (((Throwable)((Object)errors)).getSuppressed().length > 0) {
                notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)((Object)errors)));
            }
            this.ignoreRule.runNotifier = null;
        }
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        if (method.getAnnotation(Ignore.class) != null || method.getAnnotation(RandomBug.Repeat.class) != null && RandomBug.getMode() == RandomBug.MODE.BYPASS) {
            notifier.fireTestIgnored(this.describeChild(method));
            return;
        }
        this.beforeSetup();
        try {
            super.runChild(method, notifier);
        }
        finally {
            this.afterTeardown();
        }
    }

    public Object createTest() throws Exception {
        Object test = this.injector.getInstance(this.getTestClass().getJavaClass());
        try {
            this.testCreated(test);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to prepare test instance: " + test, e);
        }
        return test;
    }

    protected void validateZeroArgConstructor(List<Throwable> errors) {
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        return new InvokeMethod(method, test);
    }

    public String toString() {
        return "FeaturesRunner [fTest=" + this.getTargetTestClass() + "]";
    }

    protected List<MethodRule> rules(Object target) {
        List rules = super.rules(target);
        rules.add(this.ignoreRule);
        rules.add(this.randomBugRule);
        return rules;
    }

    protected void invokeFeatures(List<RunnerFeature> features, FeatureCallable callable) {
        AssertionError errors = new AssertionError((Object)("invoke on features error " + features));
        for (RunnerFeature feature : features) {
            try {
                callable.call(feature);
            }
            catch (AssumptionViolatedException cause) {
                throw cause;
            }
            catch (Exception cause) {
                ((Throwable)((Object)errors)).addSuppressed(cause);
            }
        }
        if (((Throwable)((Object)errors)).getSuppressed().length > 0) {
            throw errors;
        }
    }

    protected static interface FeatureCallable {
        public void call(RunnerFeature var1) throws Exception;
    }

    protected class InvokeMethod
    extends Statement {
        protected final FrameworkMethod testMethod;
        protected final Object target;

        protected InvokeMethod(FrameworkMethod testMethod, Object target) {
            this.testMethod = testMethod;
            this.target = target;
        }

        public void evaluate() throws Throwable {
            FeaturesRunner.this.beforeMethodRun(this.testMethod, this.target);
            try {
                this.testMethod.invokeExplosively(this.target, new Object[0]);
            }
            finally {
                FeaturesRunner.this.afterMethodRun(this.testMethod, this.target);
            }
        }
    }
}

