/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import com.google.inject.Binder;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.runners.model.FrameworkMethod;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.SimpleFeature;

public class LogCaptureFeature
extends SimpleFeature {
    protected Filter logCaptureFilter;
    protected final Result myResult = new Result();
    protected Logger rootLogger = Logger.getRootLogger();
    protected Appender logAppender = new AppenderSkeleton(){

        public boolean requiresLayout() {
            return false;
        }

        public void close() {
        }

        protected void append(LoggingEvent event) {
            if (LogCaptureFeature.this.logCaptureFilter == null) {
                LogCaptureFeature.this.myResult.setNoFilterFlag(true);
                return;
            }
            if (LogCaptureFeature.this.logCaptureFilter.accept(event)) {
                LogCaptureFeature.this.myResult.caughtEvents.add(event);
            }
        }
    };
    private Filter setupCaptureFiler;

    @Override
    public void configure(FeaturesRunner runner, Binder binder) {
        binder.bind(Result.class).toInstance((Object)this.myResult);
    }

    @Override
    public void beforeSetup(FeaturesRunner runner) throws Exception {
        super.beforeSetup(runner);
        FilterWith filterProvider = runner.getConfig(FilterWith.class);
        if (filterProvider.value() == null) {
            return;
        }
        Class<? extends Filter> filterClass = filterProvider.value();
        this.enable(filterClass);
    }

    @Override
    public void afterTeardown(FeaturesRunner runner) throws Exception {
        this.disable();
    }

    @Override
    public void beforeMethodRun(FeaturesRunner runner, FrameworkMethod method, Object test) throws Exception {
        FilterWith filterProvider = runner.getConfig(method, FilterWith.class);
        if (filterProvider.value() == null) {
            return;
        }
        Class<? extends Filter> filterClass = filterProvider.value();
        this.enable(filterClass);
    }

    @Override
    public void afterMethodRun(FeaturesRunner runner, FrameworkMethod method, Object test) throws Exception {
        this.disable();
    }

    protected void enable(Class<? extends Filter> filterClass) throws InstantiationException, IllegalAccessException {
        if (this.logCaptureFilter != null) {
            this.setupCaptureFiler = this.logCaptureFilter;
        } else {
            this.rootLogger.addAppender(this.logAppender);
        }
        this.logCaptureFilter = filterClass.newInstance();
    }

    protected void disable() {
        if (this.setupCaptureFiler != null) {
            this.logCaptureFilter = this.setupCaptureFiler;
            this.setupCaptureFiler = null;
            return;
        }
        if (this.logCaptureFilter != null) {
            this.myResult.clear();
            this.rootLogger.removeAppender(this.logAppender);
            this.logCaptureFilter = null;
        }
    }

    public static interface Filter {
        public boolean accept(LoggingEvent var1);
    }

    public class Result {
        protected final ArrayList<LoggingEvent> caughtEvents = new ArrayList();
        protected boolean noFilterFlag = false;

        public void assertHasEvent() throws NoLogCaptureFilterException {
            if (this.noFilterFlag) {
                throw new NoLogCaptureFilterException();
            }
            Assert.assertFalse((String)"No log result found", (boolean)this.caughtEvents.isEmpty());
        }

        public void clear() {
            this.caughtEvents.clear();
            this.noFilterFlag = false;
        }

        public List<LoggingEvent> getCaughtEvents() {
            return this.caughtEvents;
        }

        protected void setNoFilterFlag(boolean noFilterFlag) {
            this.noFilterFlag = noFilterFlag;
        }
    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface FilterWith {
        public Class<? extends Filter> value();
    }

    public class NoLogCaptureFilterException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

