/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner.web;

import org.nuxeo.runtime.test.runner.web.DriverFactory;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;

public enum BrowserFamily {
    FIREFOX,
    IE,
    CHROME,
    HTML_UNIT,
    HTML_UNIT_JS;


    public DriverFactory getDriverFactory() {
        switch (this) {
            case FIREFOX: {
                return new FirefoxDriverFactory();
            }
            case IE: {
                return new IEDriverFactory();
            }
            case CHROME: {
                return new ChromeDriverFactory();
            }
            case HTML_UNIT_JS: {
                return new HtmlUnitJsDriverFactory();
            }
        }
        return new HtmlUnitDriverFactory();
    }

    class HtmlUnitJsDriverFactory
    implements DriverFactory {
        HtmlUnitJsDriverFactory() {
        }

        @Override
        public WebDriver createDriver() {
            HtmlUnitDriver driver = new HtmlUnitDriver();
            driver.setJavascriptEnabled(true);
            return driver;
        }

        @Override
        public void disposeDriver(WebDriver driver) {
        }

        @Override
        public BrowserFamily getBrowserFamily() {
            return BrowserFamily.this;
        }
    }

    class HtmlUnitDriverFactory
    implements DriverFactory {
        HtmlUnitDriverFactory() {
        }

        @Override
        public WebDriver createDriver() {
            return new HtmlUnitDriver();
        }

        @Override
        public void disposeDriver(WebDriver driver) {
        }

        @Override
        public BrowserFamily getBrowserFamily() {
            return BrowserFamily.this;
        }
    }

    class IEDriverFactory
    implements DriverFactory {
        IEDriverFactory() {
        }

        @Override
        public WebDriver createDriver() {
            InternetExplorerDriver driver = new InternetExplorerDriver();
            return driver;
        }

        @Override
        public void disposeDriver(WebDriver driver) {
        }

        @Override
        public BrowserFamily getBrowserFamily() {
            return BrowserFamily.this;
        }
    }

    class ChromeDriverFactory
    implements DriverFactory {
        ChromeDriverFactory() {
        }

        @Override
        public WebDriver createDriver() {
            ChromeDriver ff = new ChromeDriver();
            return ff;
        }

        @Override
        public void disposeDriver(WebDriver driver) {
        }

        @Override
        public BrowserFamily getBrowserFamily() {
            return BrowserFamily.this;
        }
    }

    class FirefoxDriverFactory
    implements DriverFactory {
        FirefoxDriverFactory() {
        }

        @Override
        public WebDriver createDriver() {
            FirefoxDriver ff = new FirefoxDriver();
            return ff;
        }

        @Override
        public void disposeDriver(WebDriver driver) {
        }

        @Override
        public BrowserFamily getBrowserFamily() {
            return BrowserFamily.this;
        }
    }
}

