/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.cms;

import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.osivia.portal.api.cms.CMSContext;
import org.osivia.portal.api.cms.UniversalID;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locale.ILocaleService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.windows.WindowFactory;

public class CMSController {
    private final PortalControllerContext portalCtx;
    private ILocaleService localeService;
    private boolean superUserMode = false;
    private boolean preview;
    private Locale locale;

    public CMSController(PortalControllerContext portalCtx) {
        this.portalCtx = portalCtx;
        if (portalCtx.getRequest() != null) {
            String sLocale;
            String sPreview = WindowFactory.getWindow((PortletRequest)portalCtx.getRequest()).getProperty("osivia.content.preview");
            if (sPreview == null) {
                sPreview = WindowFactory.getWindow((PortletRequest)portalCtx.getRequest()).getPageProperty("osivia.content.preview");
            }
            if ((sLocale = WindowFactory.getWindow((PortletRequest)portalCtx.getRequest()).getProperty("osivia.content.locale")) == null) {
                sLocale = WindowFactory.getWindow((PortletRequest)portalCtx.getRequest()).getPageProperty("osivia.content.locale");
            }
            this.preview = BooleanUtils.toBoolean((String)sPreview);
            if (sLocale != null) {
                this.locale = new Locale(sLocale);
            }
        }
    }

    public CMSController(PortalControllerContext portalCtx, boolean superUser) {
        this(portalCtx);
        this.superUserMode = superUser;
    }

    public void setSuperUserMode(boolean superUserMode) {
        this.superUserMode = superUserMode;
    }

    public void addContentRefToProperties(Map<String, String> properties, String propertyName, UniversalID id) {
        properties.put(propertyName, id.toString());
        this.writeContextToProperty(properties);
    }

    public void writeContextToProperty(Map<String, String> properties) {
        properties.put("osivia.content.preview", BooleanUtils.toStringTrueFalse((boolean)this.getCMSContext().isPreview()));
        if (this.getCMSContext().getlocale() != null) {
            properties.put("osivia.content.locale", this.getCMSContext().getlocale().toString());
        }
    }

    public ILocaleService getLocaleService() {
        if (this.localeService == null) {
            this.localeService = (ILocaleService)Locator.getService(ILocaleService.class);
        }
        return this.localeService;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public CMSContext getCMSContext() {
        CMSContext cmsContext = new CMSContext(this.portalCtx);
        cmsContext.setPreview(this.preview);
        try {
            cmsContext.setLocale(this.locale);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        cmsContext.setSuperUserMode(this.superUserMode);
        return cmsContext;
    }
}

