/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.cms;

import java.io.Serializable;

public class UniversalID
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String repositoryName;
    private final String internalID;

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getInternalID() {
        return this.internalID;
    }

    public UniversalID(String repositoryName, String internalID) {
        this.repositoryName = repositoryName;
        this.internalID = internalID;
    }

    public UniversalID(String id) {
        int separatorIndex = id.indexOf(":");
        if (separatorIndex == -1) {
            throw new IllegalArgumentException("incorrect ID " + id);
        }
        this.repositoryName = id.substring(0, separatorIndex);
        this.internalID = id.substring(separatorIndex + 1);
    }

    public String toString() {
        return this.repositoryName + ":" + this.internalID;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.internalID == null ? 0 : this.internalID.hashCode());
        result = 31 * result + (this.repositoryName == null ? 0 : this.repositoryName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UniversalID other = (UniversalID)obj;
        if (this.internalID == null ? other.internalID != null : !this.internalID.equals(other.internalID)) {
            return false;
        }
        return !(this.repositoryName == null ? other.repositoryName != null : !this.repositoryName.equals(other.repositoryName));
    }
}

