/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.locator;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.osivia.portal.api.locator.LocatorInvocationHandler;
import org.springframework.context.ApplicationContext;

public class Locator {
    private static ApplicationContext APPLICATION_CONTEXT;

    public static void registerApplicationContext(ApplicationContext applicationContext) {
        APPLICATION_CONTEXT = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return APPLICATION_CONTEXT;
    }

    public static <T> T getService(Class<T> requiredType) throws IllegalArgumentException {
        return Locator.getService(null, requiredType);
    }

    public static <T> T getService(String name, Class<T> requiredType) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        LocatorInvocationHandler invocationHandler = new LocatorInvocationHandler(name, requiredType);
        Object proxy = Proxy.newProxyInstance(classLoader, new Class[]{requiredType}, (InvocationHandler)invocationHandler);
        if (!requiredType.isAssignableFrom(proxy.getClass())) {
            throw new IllegalArgumentException();
        }
        Object result = proxy;
        return (T)result;
    }

    @Deprecated
    public static <T> T findMBean(Class<T> requiredType, String name) {
        return Locator.getService(name, requiredType);
    }
}

