/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.error;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.lang3.StringUtils;
import org.osivia.portal.api.portalobject.bridge.PortalObjectUtils;
import org.osivia.portal.core.utils.URLUtils;

public class ErrorValve
extends ValveBase {
    public static ThreadLocal<Request> mainRequest = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException, IllegalStateException {
        response.setCharacterEncoding("UTF-8");
        request.getCoyoteRequest().getMimeHeaders().setValue("Accept-Language").setString("fr-FR");
        mainRequest.set(request);
        try {
            this.getNext().invoke(request, response);
            int httpErrorCode = 0;
            Exception cause = null;
            HttpServletRequest httpRequest = request.getRequest();
            String errorPageUri = PortalObjectUtils.getHostErrorPageURI(httpRequest);
            if (errorPageUri == null) {
                errorPageUri = System.getProperty("error.defaultPageUri");
            }
            if (request.getDecodedRequestURI().equals(errorPageUri)) {
                return;
            }
            if (response.getStatus() == 500) {
                httpErrorCode = 500;
            }
            if (response.getStatus() == 404) {
                httpErrorCode = 404;
            }
            if (response.getStatus() == 403) {
                httpErrorCode = 403;
            }
            if (response.getStatus() == 401) {
                httpErrorCode = 401;
            }
            if (httpErrorCode > 0) {
                cause = (Exception)request.getAttribute("osivia.error_exception");
                if (cause == null) {
                    cause = (Exception)request.getAttribute("javax.servlet.error.exception");
                }
                String token = (String)request.getAttribute("osivia.log.token");
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("osivia.url", request.getDecodedRequestURI());
                properties.put("osivia.header.userAgent", request.getHeader("User-Agent"));
                if (!(response.getStatus() != 500 && response.getStatus() != 403 && response.getStatus() != 401 && response.getStatus() != 404 || "1".equals(request.getAttribute("osivia.no_redirection")))) {
                    HashMap<String, String> parameters = new HashMap<String, String>(2);
                    parameters.put("httpCode", String.valueOf(httpErrorCode));
                    parameters.put("token", URLEncoder.encode(StringUtils.trimToEmpty((String)token), "UTF-8"));
                    String url = URLUtils.createUrl(httpRequest, errorPageUri, parameters);
                    request.removeAttribute("javax.servlet.error.exception");
                    response.sendRedirect(url);
                }
            }
        }
        finally {
            mainRequest.set(null);
        }
    }
}

