/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.customizer.plugin.fragment;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterException;
import fr.toutatice.portail.cms.nuxeo.api.forms.IFormsService;
import fr.toutatice.portail.cms.nuxeo.api.fragment.FragmentModule;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.portlet.ActionRequest;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.demo.customizer.plugin.DemoUtils;
import org.osivia.demo.customizer.plugin.fragment.ProduitRecordFragmentModule;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.portlet.model.UploadedFile;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class ProduitRecordFragmentModule
extends FragmentModule {
    public static final String ID = "record_property";
    public static final String NUXEO_PATH_WINDOW_PROPERTY = "osivia.cms.uri";
    private static final String LAUNCH_PROCEDURE_PROPERTY = "osivia.launch.procedure.webid";
    private static final String SUPPORT_PROCEDURE_WEBID = "procedure_demande_support";
    private static final String SUPPORT_PROCEDURE_SUBMIT_ACTION_ID = "00";
    private static final String TEMPORARY_FILE_PREFIX = "procedure-file-";
    private static final String TEMPORARY_FILE_SUFFIX = ".tmp";
    private static final String JSP_NAME = "product";
    private INotificationsService notificationsService = (INotificationsService)Locator.findMBean(INotificationsService.class, (String)"osivia:service=NotificationsService");
    private IBundleFactory bundleFactory;

    public ProduitRecordFragmentModule(PortletContext portletContext) {
        super(portletContext);
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public void doView(PortalControllerContext portalControllerContext) throws PortletException {
        NuxeoDocumentContext documentContext;
        Document document;
        PropertyMap docProperties;
        PropertyMap dataMap;
        PortletRequest request = portalControllerContext.getRequest();
        RenderResponse response = (RenderResponse)portalControllerContext.getResponse();
        NuxeoController nuxeoController = new NuxeoController(request, (PortletResponse)response, portalControllerContext.getPortletCtx());
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String nuxeoPath = window.getProperty(NUXEO_PATH_WINDOW_PROPERTY);
        if (StringUtils.isNotEmpty((String)nuxeoPath) && (dataMap = (docProperties = (document = (documentContext = nuxeoController.getDocumentContext(nuxeoPath = nuxeoController.getComputedPath(nuxeoPath))).getDenormalizedDocument()).getProperties()).getMap("rcd:data")) != null) {
            request.setAttribute("title", (Object)dataMap.getString("_title"));
            request.setAttribute("produitWebid", (Object)docProperties.getString("ttc:webid"));
            PropertyMap visuelMap = dataMap.getMap("visuel");
            if (visuelMap != null) {
                request.setAttribute("visuelUrl", (Object)DemoUtils.getFileUrl((NuxeoController)nuxeoController, (PropertyMap)docProperties, (String)visuelMap.getString("digest"), (String)document.getPath()));
                request.setAttribute("visuelFilename", (Object)visuelMap.getString("fileName"));
            }
            request.setAttribute("description", (Object)dataMap.getString("description"));
            PropertyList documentsList = dataMap.getList("documents");
            if (documentsList != null) {
                ArrayList<ProduitDocument> files = new ArrayList<ProduitDocument>();
                for (Object documentO : documentsList.list()) {
                    PropertyMap documentMap = (PropertyMap)documentO;
                    PropertyMap documentDataMap = documentMap.getMap("rcd:data");
                    if (documentDataMap == null) continue;
                    files.add(this.buildProduitDocument(nuxeoController, documentMap, documentDataMap));
                }
                request.setAttribute("files", files);
            }
        }
    }

    private ProduitDocument buildProduitDocument(NuxeoController nuxeoController, PropertyMap documentMap, PropertyMap documentDataMap) {
        String documentPath = documentMap.getString("ecm:path");
        PropertyMap fichierMap = documentDataMap.getMap("fichier");
        String fileDigest = fichierMap.getString("digest");
        String fileUrl = DemoUtils.getFileUrl((NuxeoController)nuxeoController, (PropertyMap)documentMap, (String)fileDigest, (String)documentPath);
        ProduitDocument upFile = new ProduitDocument(this);
        upFile.setUrl(fileUrl);
        upFile.setIcon(DemoUtils.getFileIcon((PropertyMap)documentMap, (String)fileDigest));
        upFile.setFileName(fichierMap.getString("fileName"));
        upFile.setDocumentTitle(documentDataMap.getString("_title"));
        return upFile;
    }

    public void doAdmin(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String nuxeoPath = window.getProperty(NUXEO_PATH_WINDOW_PROPERTY);
        request.setAttribute("nuxeoPath", (Object)nuxeoPath);
        String procedureWebid = window.getProperty(LAUNCH_PROCEDURE_PROPERTY);
        request.setAttribute("procedureWebid", (Object)procedureWebid);
    }

    public void processAction(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        if ("admin".equals(request.getPortletMode().toString()) && "save".equals(request.getParameter("javax.portlet.action"))) {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            window.setProperty(NUXEO_PATH_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("nuxeoPath")));
            window.setProperty(LAUNCH_PROCEDURE_PROPERTY, StringUtils.trimToNull((String)request.getParameter("procedureWebid")));
        } else if ("view".equals(request.getPortletMode().toString()) && "submit".equals(request.getParameter("javax.portlet.action"))) {
            NuxeoController nuxeoController = new NuxeoController(request, response, portalControllerContext.getPortletCtx());
            IFormsService formsService = nuxeoController.getNuxeoCMSService().getFormsService();
            if (request instanceof ActionRequest) {
                DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
                PortletFileUpload fileUpload = new PortletFileUpload((FileItemFactory)fileItemFactory);
                try {
                    List parseRequest = fileUpload.parseRequest((ActionRequest)request);
                    HashMap<String, String> variables = new HashMap<String, String>(2);
                    HashMap uploadedFiles = new HashMap(1);
                    for (FileItem fileItem : parseRequest) {
                        if (fileItem.isFormField()) {
                            if (StringUtils.equals((String)"supportText", (String)fileItem.getFieldName())) {
                                variables.put("demande", fileItem.getString());
                                continue;
                            }
                            if (!StringUtils.equals((String)"produit", (String)fileItem.getFieldName())) continue;
                            variables.put("produit", fileItem.getString());
                            continue;
                        }
                        this.addUploadedFile(uploadedFiles, fileItem);
                    }
                    formsService.start(portalControllerContext, SUPPORT_PROCEDURE_WEBID, SUPPORT_PROCEDURE_SUBMIT_ACTION_ID, variables, uploadedFiles);
                    Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
                    this.notificationsService.addSimpleNotification(portalControllerContext, bundle.getString("FRAGMENT_PRODUCT_RECORD_SUPPORT_SUCCESS"), NotificationsType.SUCCESS);
                }
                catch (IOException | FileUploadException | PortalException e) {
                    throw new PortletException(e);
                }
                catch (FormFilterException e) {
                    this.notificationsService.addSimpleNotification(portalControllerContext, e.getMessage(), NotificationsType.ERROR);
                }
            }
        }
    }

    private void addUploadedFile(Map<String, UploadedFile> uploadedFiles, FileItem fileItem) throws IOException {
        if (fileItem.getSize() > 0L) {
            ProcedureUploadedFile uploadedFile = new ProcedureUploadedFile(this);
            uploadedFile.setUpload(null);
            File temporaryFile = File.createTempFile(TEMPORARY_FILE_PREFIX, TEMPORARY_FILE_SUFFIX);
            temporaryFile.deleteOnExit();
            FileUtils.writeByteArrayToFile((File)temporaryFile, (byte[])fileItem.get());
            uploadedFile.setTemporaryFile(temporaryFile);
            uploadedFile.setTemporaryMetadata(this.getFileMetadata(fileItem));
            uploadedFile.setDeleted(false);
            uploadedFiles.put("pj", (UploadedFile)uploadedFile);
        }
    }

    private ProcedureUploadedFileMetadata getFileMetadata(FileItem fileItem) {
        MimeType mimeType;
        ProcedureUploadedFileMetadata metadata = new ProcedureUploadedFileMetadata(this);
        metadata.setFileName(FilenameUtils.getName((String)fileItem.getName()));
        try {
            mimeType = new MimeType(fileItem.getContentType());
        }
        catch (MimeTypeParseException e) {
            mimeType = null;
        }
        metadata.setMimeType(mimeType);
        String icon = DocumentDAO.getInstance().getIcon(mimeType);
        metadata.setIcon(icon);
        return metadata;
    }

    public String getViewJSPName() {
        return JSP_NAME;
    }

    public String getAdminJSPName() {
        return JSP_NAME;
    }

    public boolean isDisplayedInAdmin() {
        return true;
    }
}

