/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.taglib.toutatice;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.taglib.common.ToutaticeSimpleTag;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.io.HTMLWriter;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.core.cms.CMSException;

public class UserTag
extends ToutaticeSimpleTag {
    private String name;
    private boolean linkable = true;
    private boolean hideAvatar = false;
    private boolean hideDisplayName = false;

    @Override
    protected void doTag(NuxeoController nuxeoController, DocumentDTO document) throws JspException, IOException {
        if (StringUtils.isNotBlank((String)this.name)) {
            String url;
            String displayName;
            Element container = DOM4JUtils.generateElement((String)"span", null, null);
            if (this.linkable || !this.hideDisplayName) {
                PersonService personService = (PersonService)DirServiceFactory.getService(PersonService.class);
                Person person = personService.getPerson(this.name);
                if (person != null) {
                    Link link;
                    displayName = StringUtils.defaultIfBlank((String)person.getDisplayName(), (String)this.name);
                    url = this.linkable ? ((link = this.getTagService().getUserProfileLink(nuxeoController, this.name, displayName)) == null ? null : link.getUrl()) : null;
                } else {
                    displayName = this.name;
                    url = null;
                }
            } else {
                displayName = null;
                url = null;
            }
            if (!this.hideAvatar) {
                Element avatar;
                String avatarHtmlClass;
                Element avatarContainer;
                if (!this.hideDisplayName) {
                    avatarContainer = container;
                    avatarHtmlClass = "avatar";
                } else {
                    avatarContainer = DOM4JUtils.generateLinkElement(url, null, null, (String)"no-ajax-link", null);
                    container.add(avatarContainer);
                    avatarHtmlClass = null;
                }
                try {
                    Link link = nuxeoController.getUserAvatar(this.name);
                    if (link == null) {
                        avatar = null;
                    } else {
                        avatar = DOM4JUtils.generateElement((String)"img", (String)avatarHtmlClass, null);
                        DOM4JUtils.addAttribute((Element)avatar, (String)"src", (String)link.getUrl());
                        DOM4JUtils.addAttribute((Element)avatar, (String)"alt", (String)"");
                    }
                }
                catch (CMSException e) {
                    avatar = null;
                }
                if (avatar == null) {
                    avatar = DOM4JUtils.generateElement((String)"span", null, null, (String)"glyphicons glyphicons-user", null);
                }
                avatarContainer.add(avatar);
            }
            if (!this.hideDisplayName) {
                Element content = url == null ? DOM4JUtils.generateElement((String)"span", null, (String)displayName) : DOM4JUtils.generateLinkElement(url, null, null, (String)"no-ajax-link", (String)displayName);
                container.add(content);
            }
            HTMLWriter htmlWriter = new HTMLWriter((Writer)this.getJspContext().getOut());
            htmlWriter.setEscapeText(false);
            htmlWriter.write(container);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLinkable(boolean linkable) {
        this.linkable = linkable;
    }

    public void setHideAvatar(boolean hideAvatar) {
        this.hideAvatar = hideAvatar;
    }

    public void setHideDisplayName(boolean hideDisplayName) {
        this.hideDisplayName = hideDisplayName;
    }
}

