/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.aspects.portlet;

import org.jboss.portal.portlet.PortletContext;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.PortletInvokerInterceptor;
import org.jboss.portal.portlet.StateEvent;
import org.jboss.portal.portlet.invocation.ActionInvocation;
import org.jboss.portal.portlet.invocation.EventInvocation;
import org.jboss.portal.portlet.invocation.PortletInvocation;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.spi.InstanceContext;
import org.jboss.portal.portlet.spi.UserContext;
import org.jboss.portal.portlet.state.AccessMode;

public class PortletCustomizationInterceptor
extends PortletInvokerInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortletInvocationResponse invoke(PortletInvocation invocation) throws IllegalArgumentException, PortletInvokerException {
        InstanceContext oldContext = invocation.getInstanceContext();
        if ((invocation instanceof ActionInvocation || invocation instanceof EventInvocation) && oldContext.getAccessMode() == AccessMode.READ_ONLY) {
            PortletContext oldTarget = invocation.getTarget();
            try {
                UserContext userContext = invocation.getUserContext();
                PortletInstanceContext newContext = new PortletInstanceContext(userContext, oldTarget);
                invocation.setInstanceContext(newContext);
                invocation.setTarget(newContext.getTarget());
                PortletInvocationResponse portletInvocationResponse = super.invoke(invocation);
                return portletInvocationResponse;
            }
            finally {
                invocation.setTarget(oldTarget);
                invocation.setInstanceContext(oldContext);
            }
        }
        return super.invoke(invocation);
    }

    private static class PortletInstanceContext
    implements InstanceContext {
        private UserContext userContext;
        private PortletContext target;
        private boolean useClone;
        private String id;

        public PortletInstanceContext(UserContext userContext, PortletContext portletContext) {
            String id = portletContext.getId();
            PortletContext target = portletContext;
            boolean useClone = false;
            PortletContext clone = (PortletContext)userContext.getAttribute("clone." + id);
            if (clone != null) {
                target = clone;
                useClone = true;
            }
            this.userContext = userContext;
            this.useClone = useClone;
            this.target = target;
            this.id = id;
        }

        public PortletContext getTarget() {
            return this.target;
        }

        public String getId() {
            return this.id;
        }

        public AccessMode getAccessMode() {
            return this.useClone ? AccessMode.READ_WRITE : AccessMode.CLONE_BEFORE_WRITE;
        }

        public void onStateEvent(StateEvent event) {
            this.target = event.getPortletContext();
            this.useClone = true;
            this.userContext.setAttribute("clone." + this.id, this.target);
        }
    }
}

