/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.controller.classic;

import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.core.controller.classic.OtherResponseHandler;
import org.jboss.portal.core.controller.command.info.ActionCommandInfo;
import org.jboss.portal.core.controller.command.info.CommandInfo;
import org.jboss.portal.core.controller.handler.AbstractResponseHandler;
import org.jboss.portal.core.controller.handler.CommandForward;
import org.jboss.portal.core.controller.handler.HTTPResponse;
import org.jboss.portal.core.controller.handler.HandlerResponse;
import org.jboss.portal.core.controller.handler.ResponseHandler;
import org.jboss.portal.core.controller.handler.ResponseHandlerException;
import org.jboss.portal.core.controller.portlet.PortletResponseHandler;
import org.jboss.portal.core.model.instance.PortletInstanceResponseHandler;
import org.jboss.portal.core.model.portal.PortalObjectResponseHandler;
import org.jboss.portal.server.request.URLContext;
import org.jboss.portal.server.request.URLFormat;

public class ClassicResponseHandler
extends AbstractResponseHandler {
    private ResponseHandler[] handlers = new ResponseHandler[]{new PortletInstanceResponseHandler(), new PortalObjectResponseHandler(), new PortletResponseHandler(), new OtherResponseHandler()};

    @Override
    public HandlerResponse processCommandResponse(ControllerContext controllerContext, ControllerCommand controllerCommand, ControllerResponse commandResponse) throws ResponseHandlerException {
        HandlerResponse handlerResponse = this.processHandlers(controllerContext, controllerCommand, commandResponse);
        if (handlerResponse instanceof CommandForward) {
            CommandForward forward = (CommandForward)handlerResponse;
            URLContext urlContext = controllerContext.getServerInvocation().getServerContext().getURLContext();
            if (this.requiresRedirect(controllerCommand, urlContext, forward)) {
                String url = controllerContext.renderURL(forward.getCommand(), forward.getURLContext(), URLFormat.newInstance((boolean)false, (boolean)true));
                return HTTPResponse.sendRedirect(url);
            }
        }
        return handlerResponse;
    }

    private HandlerResponse processHandlers(ControllerContext controllerContext, ControllerCommand command, ControllerResponse commandResponse) throws ResponseHandlerException {
        for (ResponseHandler handler : this.handlers) {
            HandlerResponse handlerResponse = handler.processCommandResponse(controllerContext, command, commandResponse);
            if (handlerResponse == null) continue;
            return handlerResponse;
        }
        return null;
    }

    public boolean requiresRedirect(ControllerCommand currentCmd, URLContext currentURLCtx, CommandForward forward) {
        CommandInfo currentCmdInfo = currentCmd.getInfo();
        if (currentCmdInfo instanceof ActionCommandInfo && !((ActionCommandInfo)currentCmdInfo).isIdempotent()) {
            return true;
        }
        URLContext nextURLCtx = forward.getURLContext();
        boolean currentAuthenticated = currentURLCtx.isAuthenticated();
        if (nextURLCtx != null && currentAuthenticated != nextURLCtx.isAuthenticated()) {
            return true;
        }
        boolean currentSecure = currentURLCtx.isSecure();
        return nextURLCtx != null && nextURLCtx.isSecure() && !currentSecure;
    }
}

