/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.bridge;

import javax.portlet.GenericPortlet;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.portals.bridges.common.ServletContextProvider;
import org.jboss.portal.portlet.bridge.BridgeResponse;
import org.jboss.portal.portlet.container.PortletContainer;
import org.jboss.portal.portlet.invocation.PortletInvocation;

public class JBossServletContextProvider
implements ServletContextProvider {
    private static final ThreadLocal local = new ThreadLocal();

    static void set(BridgeInfo info) {
        local.set(info);
    }

    public static BridgeInfo get() {
        return (BridgeInfo)local.get();
    }

    public ServletContext getServletContext(GenericPortlet genericPortlet) throws IllegalStateException {
        BridgeInfo info = (BridgeInfo)local.get();
        if (info == null) {
            throw new IllegalStateException("No bridge set");
        }
        return info.ctx;
    }

    public HttpServletRequest getHttpServletRequest(GenericPortlet genericPortlet, PortletRequest portletRequest) throws IllegalStateException {
        BridgeInfo info = (BridgeInfo)local.get();
        if (info == null) {
            throw new IllegalStateException("No bridge set");
        }
        if (info.breq == null) {
            this.init(info);
        }
        return info.breq;
    }

    public HttpServletResponse getHttpServletResponse(GenericPortlet genericPortlet, PortletResponse portletResponse) throws IllegalStateException {
        BridgeInfo info = (BridgeInfo)local.get();
        if (info == null) {
            throw new IllegalStateException("No bridge set");
        }
        if (info.breq == null) {
            this.init(info);
        }
        return info.bresp;
    }

    private void init(BridgeInfo bridgeInfo) {
        bridgeInfo.breq = bridgeInfo.getInvocation().getDispatchedRequest();
        bridgeInfo.bresp = (HttpServletResponse)new BridgeResponse(bridgeInfo);
    }

    public static class BridgeInfo {
        private final PortletInvocation invocation;
        private final ServletContext ctx;
        private HttpServletRequest breq;
        private HttpServletResponse bresp;

        public BridgeInfo(PortletInvocation invocation) {
            PortletContainer container = (PortletContainer)invocation.getAttribute("PORTLET_CONTAINER");
            this.invocation = invocation;
            this.ctx = container.getPortletApplication().getContext().getServletContext();
            this.breq = null;
            this.bresp = null;
        }

        public PortletInvocation getInvocation() {
            return this.invocation;
        }
    }
}

