/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.userworkspaces;

import fr.toutatice.ecm.platform.core.userworkspace.ToutaticeUserWorkspaceServiceImpl;
import java.io.Serializable;
import java.security.Principal;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;

public class UserWorkspaceService
extends ToutaticeUserWorkspaceServiceImpl {
    private static final long serialVersionUID = 6465767707468908495L;
    private static final String TTC_SHOW_IN_MENU = "ttc:showInMenu";
    private static final String DC_TITLE = "dc:title";

    protected DocumentModel doCreateUserWorkspace(CoreSession unrestrictedSession, PathRef wsRef, Principal principal, String userName) throws ClientException {
        DocumentModel userWorkspace = super.doCreateUserWorkspace(unrestrictedSession, wsRef, principal, userName);
        userWorkspace.setProperty("toutatice", "tabOrder", (Object)"100");
        userWorkspace.setPropertyValue(DC_TITLE, (Serializable)((Object)"Mon espace"));
        unrestrictedSession.saveDocument(userWorkspace);
        DocumentModel mesDocs = unrestrictedSession.createDocumentModel(userWorkspace.getPathAsString(), "documents", "Folder");
        mesDocs.setPropertyValue(DC_TITLE, (Serializable)((Object)"Documents"));
        mesDocs.setPropertyValue(TTC_SHOW_IN_MENU, (Serializable)Boolean.TRUE);
        unrestrictedSession.createDocument(mesDocs);
        DocumentModel mesPhotos = unrestrictedSession.createDocumentModel(userWorkspace.getPathAsString(), "gallery", "PictureBook");
        mesPhotos.setPropertyValue(DC_TITLE, (Serializable)((Object)"Galerie d'images"));
        mesPhotos.setPropertyValue(TTC_SHOW_IN_MENU, (Serializable)Boolean.TRUE);
        unrestrictedSession.createDocument(mesPhotos);
        DocumentModel monAgenda = unrestrictedSession.createDocumentModel(userWorkspace.getPathAsString(), "calendar", "Agenda");
        monAgenda.setPropertyValue(DC_TITLE, (Serializable)((Object)"Agenda"));
        monAgenda.setPropertyValue(TTC_SHOW_IN_MENU, (Serializable)Boolean.TRUE);
        unrestrictedSession.createDocument(monAgenda);
        DocumentModel publicFolder = unrestrictedSession.createDocumentModel(userWorkspace.getPathAsString(), "public", "Folder");
        publicFolder.setPropertyValue(DC_TITLE, (Serializable)((Object)"Documents partag\u00e9s"));
        publicFolder.setPropertyValue(TTC_SHOW_IN_MENU, (Serializable)Boolean.TRUE);
        unrestrictedSession.createDocument(publicFolder);
        this.setFoldersACL(publicFolder, userName);
        return userWorkspace;
    }

    protected void setFoldersACL(DocumentModel doc, String userName) throws ClientException {
        ACPImpl acp = new ACPImpl();
        ACE grantMembersRead = new ACE("Everyone", "Read", true);
        ACE grantEverything = new ACE(userName, "Everything", true);
        ACLImpl acl = new ACLImpl();
        acl.setACEs(new ACE[]{grantMembersRead, grantEverything});
        acp.addACL((ACL)acl);
        doc.setACP((ACP)acp, true);
    }
}

