/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.scheduler.calendar.view.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.demo.scheduler.calendar.view.portlet.repository.command.ListWorkspaceCommand;
import org.osivia.demo.scheduler.calendar.view.portlet.repository.command.ReservationListCommand;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.calendar.common.repository.command.EventRemoveCommand;
import org.osivia.services.calendar.view.portlet.model.CalendarOptions;
import org.osivia.services.calendar.view.portlet.model.CalendarViewForm;
import org.osivia.services.calendar.view.portlet.model.events.Event;
import org.osivia.services.calendar.view.portlet.repository.CalendarViewRepositoryImpl;
import org.osivia.services.calendar.view.portlet.repository.command.EventGetCommand;
import org.osivia.services.calendar.view.portlet.repository.command.EventListCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

@Repository
@Primary
public class CalendarViewCustomRepositoryImpl
extends CalendarViewRepositoryImpl {
    private static final String DATA_MAP = "pi:data";
    private static final String TASK_MAP = "pi:task";
    private static final String TASK_PATH = "ecm:path";
    private static final String UUID_RESERVATION_PROPERTY = "uuid";
    private static final String DATE_RESERVATION_PROPERTY = "date";
    private static final String TIME_SLOT_RESERVATION_PROPERTY = "plage";
    private static final String TITLE_RESERVATION_PROPERTY = "titre";
    private static final String TIME_SLOT_MORNING = "AM";
    private static final String TIME_SLOT_AFTERNOON = "PM";
    private static final String USER_WORKSPACES_DEFAULT_PATH = "/default-domain/UserWorkspaces";
    private static final String USER_WORKSPACES_DEFAULT_TYPE = "Workspace";
    @Autowired
    private IPortalUrlFactory urlFactory;

    public String getColorIdAgenda(PortalControllerContext portalControllerContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        Document document = this.getDocument(nuxeoController);
        if (document != null) {
            return document.getString("cal:color");
        }
        return "";
    }

    public List<Event> getEvents(PortalControllerContext portalControllerContext, Date start, Date end) throws PortletException {
        ArrayList<Event> events;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        String cmsPath = this.getCMSPath(nuxeoController);
        if (StringUtils.isEmpty((String)cmsPath)) {
            events = null;
        } else {
            List listSource = this.getSynchronizationSources(portalControllerContext);
            EventListCommand nuxeoCommand = new EventListCommand(NuxeoQueryFilterContext.CONTEXT_LIVE_N_PUBLISHED, cmsPath, start, end, listSource);
            Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)nuxeoCommand);
            events = new ArrayList<Event>();
            for (Document document : documents) {
                if (document.getDate("vevent:dtstart") == null || document.getDate("vevent:dtend") == null) continue;
                Event event = this.fillEvent(document, nuxeoController);
                events.add(event);
            }
            if (portalControllerContext.getHttpServletRequest().getUserPrincipal() != null) {
                String currentUser = portalControllerContext.getHttpServletRequest().getUserPrincipal().getName();
                List userWorkspacePath = this.getUserWorkspaces(portalControllerContext, currentUser);
                boolean isUserWorkspace = false;
                for (String workspacePath : userWorkspacePath) {
                    if (!cmsPath.startsWith(workspacePath)) continue;
                    isUserWorkspace = true;
                    break;
                }
                if (isUserWorkspace) {
                    nuxeoCommand = new ReservationListCommand(NuxeoQueryFilterContext.CONTEXT_LIVE_N_PUBLISHED, start, end, currentUser);
                    documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)nuxeoCommand);
                    for (Document document : documents) {
                        Event event = this.fillReservation(portalControllerContext, document, nuxeoController);
                        if (event == null) continue;
                        events.add(event);
                    }
                }
            }
        }
        return events;
    }

    public Event getEvent(PortalControllerContext portalControllerContext, String docid) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        String cmsPath = this.getCMSPath(nuxeoController);
        EventGetCommand nuxeoCommand = new EventGetCommand(cmsPath, docid);
        Document document = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)nuxeoCommand);
        return this.fillEvent(document, nuxeoController);
    }

    private List<String> getUserWorkspaces(PortalControllerContext portalControllerContext, String userName) throws PortletException {
        ArrayList<String> workspaces;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        String query = this.getUserWorkspacesQuery(userName);
        String schemas = "dublincore";
        String filter = "none";
        try {
            String liveStatus = Integer.toString(1);
            ListWorkspaceCommand nuxeoCommand = new ListWorkspaceCommand(query, liveStatus, 0, -1, schemas, filter);
            Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)nuxeoCommand);
            workspaces = new ArrayList<String>(documents.size());
            for (Document document : documents.list()) {
                String path = document.getPath();
                workspaces.add(path);
            }
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        return workspaces;
    }

    private String getUserWorkspacesQuery(String userName) {
        StringBuilder query = new StringBuilder();
        query.append("ecm:primaryType = '");
        query.append(USER_WORKSPACES_DEFAULT_TYPE);
        query.append("' AND ecm:path STARTSWITH '");
        query.append(USER_WORKSPACES_DEFAULT_PATH);
        query.append("/'");
        if (StringUtils.isNotEmpty((String)userName)) {
            query.append(" AND dc:creator = '");
            query.append(userName);
            query.append("'");
        }
        return query.toString();
    }

    private Event fillEvent(Document document, NuxeoController nuxeoController) {
        String id = document.getId();
        String title = document.getTitle();
        Date startDate = document.getDate("vevent:dtstart");
        Date endDate = document.getDate("vevent:dtend");
        String bckgcolor = document.getString("vevent:color");
        boolean allDay = BooleanUtils.isTrue((Boolean)document.getProperties().getBoolean("vevent:allDay"));
        String viewURL = nuxeoController.getLink(document).getUrl();
        String idEventSrc = document.getString("sync:idSource");
        String idParentSrc = document.getString("sync:idParentSource");
        return new Event(id, title, startDate, endDate, allDay, bckgcolor, viewURL, idEventSrc, idParentSrc);
    }

    private Event fillReservation(PortalControllerContext portalControllerContext, Document document, NuxeoController nuxeoController) throws PortletException {
        PropertyMap map = document.getProperties().getMap(DATA_MAP);
        String id = document.getId();
        String title = map.getString(TITLE_RESERVATION_PROPERTY);
        Date date = map.getDate(DATE_RESERVATION_PROPERTY);
        date.setTime(date.getTime() + 3600000L);
        String timeSlot = map.getString(TIME_SLOT_RESERVATION_PROPERTY);
        Date startDate = null;
        Date endDate = null;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (TIME_SLOT_MORNING.equals(timeSlot)) {
            cal.set(11, 8);
            startDate = cal.getTime();
            cal.set(11, 12);
            endDate = cal.getTime();
        } else if (TIME_SLOT_AFTERNOON.equals(timeSlot)) {
            cal.set(11, 14);
            startDate = cal.getTime();
            cal.set(11, 18);
            endDate = cal.getTime();
        }
        String url = null;
        map = document.getProperties().getMap(TASK_MAP);
        if (map == null) {
            url = nuxeoController.getLink(document).getUrl();
        } else {
            String path = map.getString(TASK_PATH);
            try {
                url = this.urlFactory.getPermaLink(portalControllerContext, null, null, path, "cms");
            }
            catch (PortalException e) {
                throw new PortletException((Throwable)e);
            }
        }
        return startDate == null ? null : new Event(id, title, startDate, endDate, false, null, url, null, null);
    }

    protected String getCMSPath(NuxeoController nuxeoController) throws PortletException {
        String cmsPath;
        CalendarOptions configuration = this.getConfiguration(nuxeoController.getPortalCtx());
        if (StringUtils.isNotBlank((String)configuration.getCmsPath())) {
            cmsPath = configuration.getCmsPath();
        } else {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)nuxeoController.getRequest());
            cmsPath = window.getPageProperty("osivia.cms.basePath");
        }
        return nuxeoController.getComputedPath(cmsPath);
    }

    public boolean isEventEditable(PortalControllerContext portalControllerContext, String docid) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        NuxeoController nuxeoController = new NuxeoController(request, portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        NuxeoDocumentContext documentContext = nuxeoController.getCurrentDocumentContext();
        return documentContext.getPermissions().isEditable();
    }

    public void remove(PortalControllerContext portalControllerContext, CalendarViewForm form) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        EventRemoveCommand command = new EventRemoveCommand(form.getDocId());
        nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
    }
}

