/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.scheduler.portlet.controller;

import java.io.IOException;
import java.io.PrintWriter;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import net.sf.json.JSONArray;
import org.osivia.demo.scheduler.portlet.model.SchedulerForm;
import org.osivia.demo.scheduler.portlet.service.SchedulerService;
import org.osivia.portal.api.context.PortalControllerContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class ViewSchedulerController {
    @Autowired
    private SchedulerService service;
    @Autowired
    private PortletContext portletContext;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response, @ModelAttribute(value="schedulerForm") SchedulerForm form) throws PortletException {
        if (form.getSessionInformations().isNeedTimeSlotLoad()) {
            PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
            this.service.loadScheduler(portalControllerContext, form);
        }
        return "view";
    }

    @ActionMapping(name="loadScheduler")
    public void loadScheduler(ActionRequest request, ActionResponse response, @ModelAttribute(value="schedulerForm") SchedulerForm form) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.loadScheduler(portalControllerContext, form);
        form.getSessionInformations().setNeedTimeSlotLoad(false);
        this.saveSessionInformations(portalControllerContext, form);
        response.setRenderParameter("view", "view");
    }

    @ActionMapping(name="startContribution")
    public void startContribution(ActionRequest request, ActionResponse response, @ModelAttribute(value="schedulerForm") SchedulerForm form, @RequestParam(value="halfDay") String halfDay, @RequestParam(value="day") String day) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (form.getSelectedContributor() != null) {
            this.service.startContribution(portalControllerContext, form.getSelectedContributor(), day, halfDay);
        }
        this.saveSessionInformations(portalControllerContext, form);
    }

    @ActionMapping(name="previousWeek")
    public void previousWeek(ActionRequest request, ActionResponse response, @ModelAttribute(value="schedulerForm") SchedulerForm form) throws PortletException, IOException {
        form.previousWeek();
        this.loadScheduler(request, response, form);
    }

    @ActionMapping(name="nextWeek")
    public void nextWeek(ActionRequest request, ActionResponse response, @ModelAttribute(value="schedulerForm") SchedulerForm form) throws PortletException, IOException {
        form.nextWeek();
        this.loadScheduler(request, response, form);
    }

    @ResourceMapping(value="searchContributor")
    public void searchContributor(ResourceRequest request, ResourceResponse response, @RequestParam(value="filter", required=false) String filter) throws PortletException, IOException {
        JSONArray results = this.service.searchContributors(filter);
        response.setContentType("application/json");
        PrintWriter printWriter = new PrintWriter(response.getPortletOutputStream());
        printWriter.write(results.toString());
        printWriter.close();
    }

    @ModelAttribute(value="schedulerForm")
    public SchedulerForm getForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getForm(portalControllerContext);
    }

    private void saveSessionInformations(PortalControllerContext portalControllerContext, SchedulerForm form) {
        portalControllerContext.getHttpServletRequest().getSession().setAttribute("schedulerDemoInformations", (Object)form.getSessionInformations());
    }
}

