/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.scheduler.portlet.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import java.util.List;
import java.util.UUID;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;

public class ProcedureInstanceListCommand
implements INuxeoCommand {
    private static final String PROCEDURE_REQUEST_FOR_INTERVENTION = "procedure_demande-intervention";
    private NuxeoQueryFilterContext queryContext;
    private final String startDate;
    private final String endDate;
    private final String intervenant;
    private final List<String> customerUsers;

    public ProcedureInstanceListCommand(NuxeoQueryFilterContext queryContext, String startDate, String endDate, String intervenant, List<String> customerUsers) {
        this.queryContext = queryContext;
        this.startDate = startDate;
        this.endDate = endDate;
        this.intervenant = intervenant;
        this.customerUsers = customerUsers;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        StringBuilder clause = new StringBuilder();
        clause.append("ecm:primaryType = 'ProcedureInstance' ");
        clause.append("and pi:procedureModelWebId = '").append(PROCEDURE_REQUEST_FOR_INTERVENTION).append("' ");
        clause.append("AND (pi:data/date between DATE '").append(this.startDate).append("' and DATE '").append(this.endDate).append("') ");
        clause.append("and pi:data/intervenant = '").append(this.intervenant).append("' ");
        clause.append("AND (pi:currentStep in ('1','2') OR pi:data/accepted = 'true') ");
        clause.append("and dc:creator in ('");
        boolean first = true;
        for (String user : this.customerUsers) {
            if (!first) {
                clause.append("','");
            }
            clause.append(user);
            first = false;
        }
        clause.append("') ");
        String filteredRequest = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)this.queryContext, (String)clause.toString());
        OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
        request.set("X-NXDocumentProperties", (Object)"*");
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredRequest));
        return request.execute();
    }

    public String getId() {
        return "ProcedureInstanceListCommand :" + UUID.randomUUID();
    }
}

