/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.generator.portlet.controller;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import javax.annotation.PostConstruct;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osivia.demo.generator.portlet.model.CreationForm;
import org.osivia.demo.generator.portlet.model.validator.CreationFormValidator;
import org.osivia.demo.generator.portlet.service.SimpleDocumentCreatorService;
import org.osivia.portal.api.context.PortalControllerContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
@SessionAttributes(value={"form"})
public class SimpleDocumentCreatorController
extends CMSPortlet {
    @Autowired
    private PortletConfig portletConfig;
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private SimpleDocumentCreatorService service;
    @Autowired
    private CreationFormValidator formValidator;

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
    }

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) {
        return "view";
    }

    @ActionMapping(name="save", params={"save"})
    public void save(ActionRequest request, ActionResponse response, @Validated @ModelAttribute(value="form") CreationForm form, BindingResult result) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (!result.hasErrors()) {
            this.service.create(portalControllerContext, form);
        }
    }

    @ActionMapping(name="save", params={"randomize"})
    public void randomize(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") CreationForm form) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.randomize(portalControllerContext, form);
    }

    @ModelAttribute(value="form")
    public CreationForm getForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getCreationForm(portalControllerContext);
    }

    @InitBinder(value={"form"})
    public void formInitBinder(WebDataBinder binder) {
        binder.addValidators(new Validator[]{this.formValidator});
    }
}

