/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.generator.portlet.service;

import io.codearte.jfairy.Fairy;
import io.codearte.jfairy.producer.text.TextProducer;
import java.beans.PropertyDescriptor;
import java.util.Locale;
import javax.portlet.PortletException;
import org.apache.commons.beanutils.PropertyUtils;
import org.osivia.demo.generator.portlet.model.CreationForm;
import org.osivia.demo.generator.portlet.repository.SimpleDocumentCreatorRepository;
import org.osivia.demo.generator.portlet.service.SimpleDocumentCreatorService;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class SimpleDocumentCreatorServiceImpl
implements SimpleDocumentCreatorService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private SimpleDocumentCreatorRepository repository;
    @Autowired
    private INotificationsService notificationsService;
    @Autowired
    private IBundleFactory bundleFactory;

    public void create(PortalControllerContext portalControllerContext, CreationForm form) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        this.repository.create(portalControllerContext, form);
        this.notificationsService.addSimpleNotification(portalControllerContext, bundle.getString("SIMPLE_DOCUMENT_CREATION_MESSAGE_SUCCESS", new Object[]{form.getTitle()}), NotificationsType.SUCCESS);
        try {
            for (PropertyDescriptor propertyDescriptor : PropertyUtils.getPropertyDescriptors(form.getClass())) {
                if (propertyDescriptor.getWriteMethod() == null) continue;
                PropertyUtils.setProperty((Object)form, (String)propertyDescriptor.getName(), null);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void randomize(PortalControllerContext portalControllerContext, CreationForm form) throws PortletException {
        Locale locale = portalControllerContext.getRequest().getLocale();
        Fairy fairy = Fairy.create((Locale)locale);
        TextProducer textProducer = fairy.textProducer();
        String title = textProducer.sentence();
        String description = textProducer.paragraph();
        form.setTitle(title);
        form.setDescription(description);
    }

    public CreationForm getCreationForm(PortalControllerContext portalControllerContext) throws PortletException {
        return (CreationForm)this.applicationContext.getBean(CreationForm.class);
    }
}

