/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.comments;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.domain.Comment;
import fr.toutatice.portail.cms.nuxeo.api.domain.ThreadPost;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCommentsService;
import fr.toutatice.portail.cms.nuxeo.portlets.comments.AddCommentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.comments.DeleteCommentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.comments.GetCommentsCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSServiceCtx;

public class NuxeoCommentsServiceImpl
implements INuxeoCommentsService {
    private final CMSService cmsService;

    public NuxeoCommentsServiceImpl(CMSService cmsService) {
        this.cmsService = cmsService;
    }

    public List<Comment> getDocumentComments(CMSServiceCtx cmsContext, Document document) throws CMSException {
        return this.getGenericComments(cmsContext, document, Comment.class);
    }

    public List<ThreadPost> getForumThreadPosts(CMSServiceCtx cmsContext, Document document) throws CMSException {
        return this.getGenericComments(cmsContext, document, ThreadPost.class);
    }

    private <T extends Comment> List<T> getGenericComments(CMSServiceCtx cmsContext, Document document, Class<T> type) throws CMSException {
        try {
            Locale locale = cmsContext.getControllerContext().getServerInvocation().getRequest().getLocale();
            GetCommentsCommand command = new GetCommentsCommand(document);
            JSONArray jsonArray = (JSONArray)this.cmsService.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
            return this.convertJSONArrayToComments(jsonArray, type, locale);
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    private <T extends Comment> List<T> convertJSONArrayToComments(JSONArray jsonArray, Class<T> type, Locale locale) throws InstantiationException, IllegalAccessException {
        ArrayList<Comment> comments = new ArrayList<Comment>(jsonArray.size());
        for (Object object : jsonArray) {
            JSONObject jsonObject = (JSONObject)object;
            Comment comment = (Comment)type.newInstance();
            if (jsonObject.containsKey((Object)"id")) {
                String id = jsonObject.getString("id");
                comment.setId(id);
            }
            if (jsonObject.containsKey((Object)"path")) {
                String path = jsonObject.getString("path");
                comment.setPath(path);
            }
            if (jsonObject.containsKey((Object)"author")) {
                String author = jsonObject.getString("author");
                comment.setAuthor(author);
            }
            if (jsonObject.containsKey((Object)"creationDate")) {
                JSONObject jsonObjectDate = jsonObject.getJSONObject("creationDate");
                Long time = (Long)jsonObjectDate.get("timeInMillis");
                DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 3, locale);
                String formattedDate = dateFormat.format(time);
                comment.setCreationDate(formattedDate);
            }
            if (jsonObject.containsKey((Object)"content")) {
                String content = jsonObject.getString("content");
                comment.setContent(content);
            }
            if (jsonObject.containsKey((Object)"canDelete")) {
                boolean deletable = jsonObject.getBoolean("canDelete");
                comment.setDeletable(deletable);
            }
            if (comment instanceof ThreadPost) {
                ThreadPost threadPost = (ThreadPost)comment;
                if (jsonObject.containsKey((Object)"title")) {
                    String title = jsonObject.getString("title");
                    threadPost.setTitle(title);
                }
                if (jsonObject.containsKey((Object)"filename")) {
                    String filename = jsonObject.getString("filename");
                    threadPost.setFilename(filename);
                }
            }
            if (jsonObject.containsKey((Object)"children")) {
                JSONArray children = jsonObject.getJSONArray("children");
                List commentChildren = this.convertJSONArrayToComments(children, type, locale);
                comment.setChildren(commentChildren);
            }
            comments.add(comment);
        }
        return comments;
    }

    public void addDocumentComment(CMSServiceCtx cmsContext, Document document, Comment comment, String parentId) throws CMSException {
        try {
            AddCommentCommand command = new AddCommentCommand(document, comment, parentId);
            this.cmsService.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public void deleteDocumentComment(CMSServiceCtx cmsContext, Document document, String id) throws CMSException {
        try {
            DeleteCommentCommand command = new DeleteCommentCommand(document, id);
            this.cmsService.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }
}

