/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCommentsService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import fr.toutatice.portail.cms.nuxeo.portlets.comments.CommentsFormatter;
import fr.toutatice.portail.cms.nuxeo.portlets.comments.NuxeoCommentsServiceImpl;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.FragmentType;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.IFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.ListTemplate;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.CMSItemAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.CMSToWebPathAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.DefaultPlayer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.DocumentPictureFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.EditableWindowAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.IPlayer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.LinkFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.MenuBarFormater;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.NavigationItemAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.NavigationPictureFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.PropertyFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.SpaceMenuBarFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.UserPagesLoader;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfiguratinQueryCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfigurationHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WysiwygParser;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.XSLFunctions;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.ZoomFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import fr.toutatice.portail.cms.nuxeo.portlets.service.DocumentPublishSpaceNavigationCommand;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletContext;
import javax.portlet.ResourceURL;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.portal.common.invocation.Scope;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.server.ServerInvocation;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSHandlerProperties;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSItemType;
import org.osivia.portal.core.cms.CMSPage;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.page.PageProperties;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class DefaultCMSCustomizer
implements INuxeoCustomizer {
    public static final String STYLE_MINI = "mini";
    public static final String STYLE_NORMAL = "normal";
    public static final String STYLE_DETAILED = "detailed";
    public static final String STYLE_EDITORIAL = "editorial";
    public static final String DEFAULT_SCHEMAS = "dublincore,common, toutatice, file";
    public static final String TEMPLATE_DOWNLOAD = "download";
    private PortletContext portletCtx;
    private IPortalUrlFactory portalUrlFactory;
    private UserPagesLoader userPagesLoader;
    private MenuBarFormater menuBarFormater;
    private NavigationItemAdapter navigationItemAdapter;
    private CMSItemAdapter cmsItemAdapter;
    private NuxeoConnectionProperties nuxeoConnection;
    private XMLReader parser;
    private EditableWindowAdapter editableWindowAdapter;
    private CMSToWebPathAdapter cmsToWebAdapter;
    private INuxeoCommentsService commentsService;
    private ClassLoader cl;
    private Map<String, CMSItemType> cmsItemTypes;
    private final Map<String, IPlayer> players;
    private CMSService cmsService;

    public DefaultCMSCustomizer(PortletContext ctx) {
        this.portletCtx = ctx;
        this.portalUrlFactory = (IPortalUrlFactory)this.portletCtx.getAttribute("UrlService");
        this.players = new HashMap();
        this.players.put("defaultPlayer", new DefaultPlayer());
        try {
            this.cl = Thread.currentThread().getContextClassLoader();
            this.parser = WysiwygParser.getInstance().getParser();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public NuxeoConnectionProperties getNuxeoConnectionProps() {
        if (this.nuxeoConnection == null) {
            this.nuxeoConnection = new NuxeoConnectionProperties();
        }
        return this.nuxeoConnection;
    }

    public UserPagesLoader getUserPagesLoader() {
        if (this.userPagesLoader == null) {
            this.userPagesLoader = new UserPagesLoader(this.portletCtx, this, this.cmsService);
        }
        return this.userPagesLoader;
    }

    public MenuBarFormater getMenuBarFormater() {
        if (this.menuBarFormater == null) {
            this.menuBarFormater = new MenuBarFormater(this.portletCtx, this, this.cmsService);
        }
        return this.menuBarFormater;
    }

    public NavigationItemAdapter getNavigationItemAdapter() {
        if (this.navigationItemAdapter == null) {
            this.navigationItemAdapter = new NavigationItemAdapter(this.portletCtx, this, this.cmsService);
        }
        return this.navigationItemAdapter;
    }

    public CMSItemAdapter getCMSItemAdapter() {
        if (this.cmsItemAdapter == null) {
            this.cmsItemAdapter = new CMSItemAdapter(this.portletCtx, this, this.cmsService);
        }
        return this.cmsItemAdapter;
    }

    public EditableWindowAdapter getEditableWindowAdapter() {
        if (this.editableWindowAdapter == null) {
            this.editableWindowAdapter = new EditableWindowAdapter();
        }
        return this.editableWindowAdapter;
    }

    public CMSToWebPathAdapter getCMSToWebPathAdapter() {
        if (this.cmsToWebAdapter == null) {
            this.cmsToWebAdapter = new CMSToWebPathAdapter(this.cmsService);
        }
        return this.cmsToWebAdapter;
    }

    public INuxeoCommentsService getNuxeoCommentsService() {
        if (this.commentsService == null) {
            this.commentsService = new NuxeoCommentsServiceImpl(this.cmsService);
        }
        return this.commentsService;
    }

    public static List<ListTemplate> getListTemplates() {
        ArrayList<ListTemplate> templates = new ArrayList<ListTemplate>();
        templates.add(new ListTemplate(STYLE_MINI, "Minimal [titre]", DEFAULT_SCHEMAS));
        templates.add(new ListTemplate(STYLE_NORMAL, "Normal [titre, date]", DEFAULT_SCHEMAS));
        templates.add(new ListTemplate(STYLE_DETAILED, "D\u00e9taill\u00e9 [titre, description, date, ...]", DEFAULT_SCHEMAS));
        templates.add(new ListTemplate(STYLE_EDITORIAL, "Editorial [vignette, titre, description]", DEFAULT_SCHEMAS));
        return templates;
    }

    public static List<FragmentType> getFragmentTypes() {
        ArrayList<FragmentType> fragmentTypes = new ArrayList<FragmentType>();
        fragmentTypes.add(new FragmentType("text_property", "Propri\u00e9t\u00e9 texte", (IFragmentModule)new PropertyFragmentModule(), "property-text", "property"));
        fragmentTypes.add(new FragmentType("html_property", "Propri\u00e9t\u00e9 html", (IFragmentModule)new PropertyFragmentModule(), "property-html", "property"));
        fragmentTypes.add(new FragmentType("zoom_property", "Liste de zooms", (IFragmentModule)new ZoomFragmentModule(), "zoom", "zoom"));
        fragmentTypes.add(new FragmentType("navigation_picture", "Visuel navigation", (IFragmentModule)new NavigationPictureFragmentModule(), "navigation-picture", "navigation"));
        fragmentTypes.add(new FragmentType("document_picture", "Image jointe", (IFragmentModule)new DocumentPictureFragmentModule(), "document-picture", "document-picture"));
        fragmentTypes.add(new FragmentType("doc_link", "Lien portail ou Nuxeo", (IFragmentModule)new LinkFragmentModule(), "link", "link"));
        fragmentTypes.add(new FragmentType("space_menubar", "MenuBar d'un Espace", (IFragmentModule)new SpaceMenuBarFragmentModule(), "space-menubar", "empty"));
        return fragmentTypes;
    }

    public static String getSearchSchema() {
        return "dublincore,common,file";
    }

    public CMSHandlerProperties getCMSDefaultPlayer(CMSServiceCtx ctx) throws Exception {
        Document doc = (Document)ctx.getDoc();
        return ((IPlayer)this.players.get("defaultPlayer")).play(ctx, doc);
    }

    protected String createFolderRequest(CMSServiceCtx ctx, boolean ordered) throws CMSException {
        String nuxeoRequest = null;
        Document doc = (Document)ctx.getDoc();
        CMSPublicationInfos pubInfos = this.cmsService.getPublicationInfos(ctx, doc.getPath());
        List navItems = null;
        if (ctx.getContextualizationBasePath() != null) {
            navItems = this.cmsService.getPortalNavigationSubitems(ctx, ctx.getContextualizationBasePath(), DocumentPublishSpaceNavigationCommand.computeNavPath((String)doc.getPath()));
        }
        if (navItems != null) {
            nuxeoRequest = "ecm:parentId = '" + pubInfos.getLiveId() + "' AND ecm:mixinType != 'Folderish'";
            nuxeoRequest = ordered ? nuxeoRequest + " order by ecm:pos" : nuxeoRequest + " order by dc:modified desc";
        } else {
            nuxeoRequest = "ecm:path STARTSWITH '" + DocumentPublishSpaceNavigationCommand.computeNavPath((String)doc.getPath()) + "' AND ecm:mixinType != 'Folderish' ";
            nuxeoRequest = ordered ? nuxeoRequest + " order by ecm:pos" : nuxeoRequest + " order by dc:modified desc";
        }
        return nuxeoRequest;
    }

    public CMSHandlerProperties getCMSAnnonceFolderPlayer(CMSServiceCtx ctx) throws CMSException {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", this.createFolderRequest(ctx, false));
        windowProperties.put("osivia.cms.style", STYLE_EDITORIAL);
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        windowProperties.put("osivia.cms.hideMetaDatas", "1");
        windowProperties.put("osivia.title", "Annonces " + doc.getTitle());
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    public CMSHandlerProperties getCMSOrderedFolderPlayer(CMSServiceCtx ctx) throws CMSException {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", this.createFolderRequest(ctx, true));
        windowProperties.put("osivia.cms.style", STYLE_EDITORIAL);
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        windowProperties.put("osivia.cms.hideMetaDatas", "1");
        windowProperties.put("osivia.title", "Dossier " + doc.getTitle());
        windowProperties.put("osivia.cms.pageSizeMax", "10");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    public CMSHandlerProperties getCMSUrlContainerPlayer(CMSServiceCtx ctx) throws CMSException {
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", this.createFolderRequest(ctx, true));
        windowProperties.put("osivia.cms.style", STYLE_EDITORIAL);
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        windowProperties.put("osivia.cms.hideMetaDatas", ctx.getHideMetaDatas());
        windowProperties.put("osivia.cms.pageSizeMax", "10");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    public CMSHandlerProperties getCMSFolderPlayer(CMSServiceCtx ctx) throws CMSException {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", this.createFolderRequest(ctx, false));
        windowProperties.put("osivia.cms.style", STYLE_EDITORIAL);
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        windowProperties.put("osivia.cms.hideMetaDatas", ctx.getHideMetaDatas());
        windowProperties.put("osivia.title", "Dossier " + doc.getTitle());
        windowProperties.put("osivia.cms.pageSizeMax", "10");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    public CMSHandlerProperties getCMSSectionPlayer(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", "ecm:path STARTSWITH '" + doc.getPath() + "' AND ecm:mixinType != 'Folderish' ORDER BY dc:modified DESC");
        windowProperties.put("osivia.cms.style", STYLE_EDITORIAL);
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        windowProperties.put("osivia.cms.hideMetaDatas", ctx.getHideMetaDatas());
        windowProperties.put("osivia.title", "Dossier " + doc.getTitle());
        windowProperties.put("osivia.cms.pageSizeMax", "10");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    public CMSHandlerProperties getCMSVirtualPagePlayer(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", doc.getString("ttc:queryPart"));
        windowProperties.put("osivia.cms.style", STYLE_EDITORIAL);
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.cms.hideMetaDatas", ctx.getHideMetaDatas());
        windowProperties.put("osivia.title", "Dossier " + doc.getTitle());
        windowProperties.put("osivia.cms.pageSizeMax", "10");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    public CMSHandlerProperties createPortletLink(CMSServiceCtx ctx, String portletInstance, String uid) {
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        windowProperties.put("osivia.cms.hideMetaDatas", ctx.getHideMetaDatas());
        windowProperties.put("osivia.cms.uri", uid);
        windowProperties.put("osivia.cms.publishPathAlreadyConverted", "1");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance(portletInstance);
        return linkProps;
    }

    public CMSHandlerProperties getCMSPlayer(CMSServiceCtx ctx) throws Exception {
        Document doc = (Document)ctx.getDoc();
        if ("UserWorkspace".equals(doc.getType())) {
            ctx.setDisplayLiveVersion("1");
            return this.createPortletLink(ctx, "toutatice-portail-cms-nuxeo-fileBrowserPortletInstance", doc.getPath());
        }
        if ("DocumentUrlContainer".equals(doc.getType())) {
            return this.getCMSUrlContainerPlayer(ctx);
        }
        if ("AnnonceFolder".equals(doc.getType())) {
            return this.getCMSAnnonceFolderPlayer(ctx);
        }
        if ("Folder".equals(doc.getType()) || "OrderedFolder".equals(doc.getType()) || "Section".equals(doc.getType())) {
            CMSItem spaceConfig;
            String spaceType;
            if (ctx.getContextualizationBasePath() != null && !doc.getTitle().startsWith("test-list") && ("Workspace".equals(spaceType = ((Document)(spaceConfig = this.cmsService.getSpaceConfig(ctx, ctx.getContextualizationBasePath())).getNativeItem()).getType()) || "UserWorkspace".equals(spaceType))) {
                ctx.setDisplayLiveVersion("1");
                CMSHandlerProperties props = this.createPortletLink(ctx, "toutatice-portail-cms-nuxeo-fileBrowserPortletInstance", doc.getPath());
                props.getWindowProperties().put("osivia.title", doc.getTitle());
                return props;
            }
            if ("Folder".equals(doc.getType())) {
                return this.getCMSFolderPlayer(ctx);
            }
            return this.getCMSOrderedFolderPlayer(ctx);
        }
        if ("PortalVirtualPage".equals(doc.getType())) {
            return this.getCMSVirtualPagePlayer(ctx);
        }
        String domainPath = WebConfigurationHelper.getDomainPath((CMSServiceCtx)ctx);
        if (domainPath != null) {
            WebConfiguratinQueryCommand command = new WebConfiguratinQueryCommand(domainPath, WebConfiguratinQueryCommand.WebConfigurationType.CMSPlayer);
            Documents configs = null;
            try {
                configs = (Documents)this.cmsService.executeNuxeoCommand(ctx, (INuxeoCommand)command);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (configs != null && configs.size() > 0) {
                for (Document config : configs) {
                    String documentType = config.getProperties().getString("wconf:code");
                    String playerInstance = config.getProperties().getString("wconf:code2");
                    if (!doc.getType().equals(documentType) || !this.players.containsKey(playerInstance)) continue;
                    HashMap<String, String> windowProperties = new HashMap<String, String>();
                    PropertyList list = config.getProperties().getList("wconf:options");
                    for (Object o : list.list()) {
                        if (!(o instanceof PropertyMap)) continue;
                        PropertyMap map = (PropertyMap)o;
                        windowProperties.put(map.get("propertyName").toString(), map.get("propertyDefaultValue").toString());
                    }
                    return ((IPlayer)this.players.get(playerInstance)).play(ctx, doc, windowProperties);
                }
            }
        }
        return ((IPlayer)this.players.get("defaultPlayer")).play(ctx, doc);
    }

    public String getDefaultExternalViewer(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        this.getNuxeoConnectionProps();
        String externalUrl = NuxeoConnectionProperties.getPublicBaseUri().toString() + "/nxdoc/default/" + doc.getId() + "/view_documents";
        return externalUrl;
    }

    public String createPortletDelegatedExternalLink(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        ResourceURL resourceURL = ctx.getResponse().createResourceURL();
        resourceURL.setResourceID(doc.getId());
        resourceURL.setParameter("type", "link");
        return resourceURL.toString();
    }

    public String createPortletDelegatedFileContentLink(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        ResourceURL resourceURL = ctx.getResponse().createResourceURL();
        resourceURL.setResourceID(doc.getId() + "/" + "file:content");
        resourceURL.setParameter("type", "file");
        resourceURL.setParameter("docPath", doc.getPath());
        resourceURL.setParameter("fieldName", "file:content");
        resourceURL.setCacheability("cacheLevelPage");
        return resourceURL.toString();
    }

    public String getNuxeoNativeViewerUrl(CMSServiceCtx ctx) {
        if ("file-browser-menu-workspace".equals(ctx.getDisplayContext())) {
            return this.getDefaultExternalViewer(ctx);
        }
        return null;
    }

    public Link createCustomLink(CMSServiceCtx ctx) throws Exception {
        Document doc = (Document)ctx.getDoc();
        String url = null;
        boolean externalLink = false;
        boolean downloadable = false;
        if (!"detailedView".equals(ctx.getDisplayContext())) {
            PropertyMap attachedFileProperties;
            if ("File".equals(doc.getType()) && TEMPLATE_DOWNLOAD.equals(ctx.getDisplayContext()) && (attachedFileProperties = doc.getProperties().getMap("file:content")) != null && !attachedFileProperties.isEmpty()) {
                url = this.createPortletDelegatedFileContentLink(ctx);
                url = this.portalUrlFactory.adaptPortalUrlToNavigation(new PortalControllerContext((Object)ctx.getControllerContext()), url);
                downloadable = true;
            }
            if ("ContextualLink".equals(doc.getType())) {
                url = this.createPortletDelegatedExternalLink(ctx);
                externalLink = true;
            }
            if (url == null) {
                url = this.getNuxeoNativeViewerUrl(ctx);
                externalLink = true;
            }
        }
        if (url != null) {
            Link link = new Link(url, externalLink);
            link.setDownloadable(downloadable);
            return link;
        }
        return null;
    }

    public void formatContentMenuBar(CMSServiceCtx ctx) throws Exception {
        this.getMenuBarFormater().formatContentMenuBar(ctx);
        List menuBar = (List)ctx.getRequest().getAttribute("osivia.menuBar");
        this.adaptContentMenuBar(ctx, menuBar);
    }

    protected void adaptContentMenuBar(CMSServiceCtx ctx, List<MenubarItem> menuBar) {
    }

    public List<CMSPage> computeUserPreloadedPages(CMSServiceCtx cmsCtx) throws Exception {
        return this.getUserPagesLoader().computeUserPreloadedPages(cmsCtx);
    }

    public Map<String, String> parseCMSURL(CMSServiceCtx cmsCtx, String requestPath, Map<String, String> requestParameters) throws Exception {
        return null;
    }

    public String adaptCMSPathToWeb(CMSServiceCtx cmsCtx, String basePath, String requestPath, boolean webPath) throws CMSException {
        return this.getCMSToWebPathAdapter().adaptCMSPathToWeb(cmsCtx, basePath, requestPath, webPath);
    }

    public Map<String, String> getDocumentConfiguration(CMSServiceCtx ctx, Document doc) throws Exception {
        return this.getCMSItemAdapter().adaptDocument(ctx, doc);
    }

    public String addPublicationFilter(CMSServiceCtx ctx, String nuxeoRequest, String requestFilteringPolicy) throws Exception {
        String extraFilter;
        String requestFilter = "";
        requestFilter = "1".equals(ctx.getDisplayLiveVersion()) ? "ecm:mixinType != 'HiddenInNavigation' AND ecm:isProxy = 0  AND ecm:currentLifeCycleState <> 'deleted'  AND ecm:isCheckedInVersion = 0 " : "ecm:isProxy = 1 AND ecm:mixinType != 'HiddenInNavigation'  AND ecm:currentLifeCycleState <> 'deleted' ";
        String policyFilter = null;
        ServerInvocation invocation = ctx.getServerInvocation();
        String portalName = (String)PageProperties.getProperties().getPagePropertiesMap().get("portalName");
        if (portalName != null) {
            PortalObjectContainer portalObjectContainer = (PortalObjectContainer)invocation.getAttribute(Scope.REQUEST_SCOPE, (Object)"osivia.portalObjectContainer");
            PortalObject po = portalObjectContainer.getObject(PortalObjectId.parse((String)"", (String)("/" + portalName), (PortalObjectPath.Format)PortalObjectPath.CANONICAL_FORMAT));
            if (requestFilteringPolicy != null) {
                policyFilter = requestFilteringPolicy;
            } else {
                String sitePolicy = po.getProperty("osivia.cms.requestFilteringPolicy");
                if (sitePolicy != null) {
                    if ("local".equals(sitePolicy)) {
                        policyFilter = "local";
                    }
                } else {
                    String portalType = po.getProperty("osivia.portal.portalType");
                    if ("space".equals(portalType)) {
                        policyFilter = "local";
                    }
                }
            }
            if ("local".equals(policyFilter)) {
                String pathFilter = "";
                for (PortalObject child : ((Portal)po).getChildren(4)) {
                    String cmsPath = child.getDeclaredProperty("osivia.cms.basePath");
                    if (cmsPath == null || cmsPath.length() <= 0) continue;
                    if (pathFilter.length() > 0) {
                        pathFilter = pathFilter + " OR ";
                    }
                    pathFilter = pathFilter + "ecm:path STARTSWITH '" + cmsPath + "'";
                }
                if (pathFilter.length() > 0) {
                    requestFilter = requestFilter + " AND " + "(" + pathFilter + ")";
                }
            }
        }
        if ((extraFilter = this.getExtraRequestFilter(ctx, requestFilteringPolicy)) != null) {
            requestFilter = requestFilter + " OR " + "(" + extraFilter + ")";
        }
        String beforeOrderBy = "";
        String orderBy = "";
        String editedNuxeoRequest = nuxeoRequest;
        try {
            Pattern ressourceExp = Pattern.compile("(.*)ORDER([ ]*)BY(.*)");
            Matcher m = ressourceExp.matcher(editedNuxeoRequest.toUpperCase());
            m.matches();
            if (m.groupCount() == 3) {
                beforeOrderBy = editedNuxeoRequest.substring(0, m.group(1).length());
                orderBy = editedNuxeoRequest.substring(m.group(1).length());
            }
        }
        catch (IllegalStateException e) {
            beforeOrderBy = editedNuxeoRequest;
        }
        String finalRequest = beforeOrderBy;
        if (finalRequest.length() > 0) {
            finalRequest = finalRequest + " AND ";
        }
        finalRequest = finalRequest + "(" + requestFilter + ") ";
        editedNuxeoRequest = finalRequest = finalRequest + " " + orderBy;
        return editedNuxeoRequest;
    }

    public String getExtraRequestFilter(CMSServiceCtx ctx, String requestFilteringPolicy) throws Exception {
        WebConfiguratinQueryCommand command;
        Documents configs;
        String extraRequetFilter = null;
        String domainPath = WebConfigurationHelper.getDomainPath((CMSServiceCtx)ctx);
        if (domainPath != null && (configs = (Documents)this.cmsService.executeNuxeoCommand(ctx, (INuxeoCommand)(command = new WebConfiguratinQueryCommand(domainPath, WebConfiguratinQueryCommand.WebConfigurationType.extraRequestFilter)))).size() > 0) {
            extraRequetFilter = "";
            int i = 0;
            for (Document config : configs) {
                String nxqlCode = config.getProperties().getString("wconf:code");
                if (nxqlCode == null) continue;
                if (i > 0) {
                    extraRequetFilter = extraRequetFilter.concat("OR");
                }
                extraRequetFilter = extraRequetFilter.concat(" ").concat(nxqlCode);
                ++i;
            }
        }
        return extraRequetFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String transformHTMLContent(CMSServiceCtx ctx, String htmlContent) throws Exception {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            Transformer transformer = WysiwygParser.getInstance().getTemplate().newTransformer();
            transformer.setParameter("bridge", new XSLFunctions(this, ctx));
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            XMLReader parser = WysiwygParser.getInstance().getParser();
            transformer.transform(new SAXSource(parser, new InputSource(new StringReader(htmlContent))), new StreamResult(output));
            String string = ((Object)output).toString();
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    public Map<String, CMSItemType> getCMSItemTypes() {
        if (this.cmsItemTypes == null) {
            List defaultTypes = this.getDefaultCMSItemTypes();
            this.cmsItemTypes = new LinkedHashMap(defaultTypes.size());
            for (CMSItemType defaultType : defaultTypes) {
                this.cmsItemTypes.put(defaultType.getName(), defaultType);
            }
        }
        return this.cmsItemTypes;
    }

    private List<CMSItemType> getDefaultCMSItemTypes() {
        ArrayList<CMSItemType> defaultTypes = new ArrayList<CMSItemType>();
        defaultTypes.add(new CMSItemType("Workspace", true, false, true, false, false, Arrays.asList("File", "Folder", "Note"), "/default/templates/workspace"));
        defaultTypes.add(new CMSItemType("PortalSite", true, false, true, true, true, Arrays.asList("File", "Folder", "Note"), null));
        defaultTypes.add(new CMSItemType("PortalPage", true, true, true, true, true, Arrays.asList("File", "Folder", "Note"), null));
        defaultTypes.add(new CMSItemType("Folder", true, true, false, false, true, Arrays.asList("File", "Folder", "Note"), null));
        defaultTypes.add(new CMSItemType("File", false, false, false, false, true, new ArrayList(0), null));
        defaultTypes.add(new CMSItemType("Note", false, false, false, false, true, new ArrayList(0), null));
        defaultTypes.add(new CMSItemType("Annonce", false, false, false, false, true, new ArrayList(0), null));
        defaultTypes.add(new CMSItemType("AnnonceFolder", true, true, false, false, false, Arrays.asList("Annonce"), null));
        defaultTypes.add(new CMSItemType("ContextualLink", false, false, false, false, true, new ArrayList(0), null));
        defaultTypes.add(new CMSItemType("DocumentUrlContainer", true, true, false, false, false, Arrays.asList("ContextualLink"), null));
        return defaultTypes;
    }

    public String getCommentsHTMLContent(CMSServiceCtx cmsContext, Document document) throws CMSException {
        List comments = this.getNuxeoCommentsService().getDocumentComments(cmsContext, document);
        CommentsFormatter formatter = new CommentsFormatter(comments);
        return formatter.generateHTMLContent();
    }

    public CMSService getCmsService() {
        return this.cmsService;
    }

    public void setCmsService(CMSService cmsService) {
        this.cmsService = cmsService;
    }

    public PortletContext getPortletCtx() {
        return this.portletCtx;
    }

    public void setPortletCtx(PortletContext portletCtx) {
        this.portletCtx = portletCtx;
    }

    public void setNavigationItemAdapter(NavigationItemAdapter navigationItemAdapter) {
        this.navigationItemAdapter = navigationItemAdapter;
    }

    public XMLReader getParser() {
        return this.parser;
    }

    public void setParser(XMLReader parser) {
        this.parser = parser;
    }
}

