/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfiguratinQueryCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfigurationHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSServiceCtx;

public class CMSToWebPathAdapter {
    private CMSService cmsService;

    public CMSToWebPathAdapter(CMSService cmsService) {
        this.cmsService = cmsService;
    }

    public String adaptCMSPathToWeb(CMSServiceCtx cmsCtx, String basePath, String requestPath, boolean webPath) throws CMSException {
        String domainPath = WebConfigurationHelper.getDomainPath((CMSServiceCtx)cmsCtx);
        if (domainPath != null) {
            WebConfiguratinQueryCommand command = new WebConfiguratinQueryCommand(domainPath, WebConfiguratinQueryCommand.WebConfigurationType.CMSToWebPathAdapter);
            Documents configs = null;
            try {
                configs = (Documents)this.cmsService.executeNuxeoCommand(cmsCtx, (INuxeoCommand)command);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (configs != null && configs.size() > 0) {
                boolean i = false;
                for (Document config : configs) {
                    String cmsPathPattern = config.getProperties().getString("wconf:code");
                    String webPathPattern = config.getProperties().getString("wconf:code2");
                    if (webPath) {
                        if (!requestPath.startsWith(webPathPattern)) continue;
                        return cmsPathPattern.concat(requestPath.substring(webPathPattern.length()));
                    }
                    if (!requestPath.startsWith(cmsPathPattern)) continue;
                    return webPathPattern.concat(requestPath.substring(cmsPathPattern.length()));
                }
            }
        }
        if (webPath) {
            return basePath + requestPath;
        }
        if (requestPath.startsWith(basePath)) {
            return requestPath.substring(basePath.length());
        }
        return null;
    }
}

