/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.document;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.core.cms.CMSBinaryContent;

public class PictureContentCommand
implements INuxeoCommand {
    Document image;
    String content;

    public PictureContentCommand(Document image, String content) {
        this.image = image;
        this.content = content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Session session) throws Exception {
        PropertyList views = this.image.getProperties().getList("picture:views");
        if (views != null) {
            for (Object viewObject : views.list()) {
                PropertyMap view;
                String title;
                if (!(viewObject instanceof PropertyMap) || !this.content.equals(title = (view = (PropertyMap)viewObject).getString("title"))) continue;
                PropertyMap fileContent = view.getMap("content");
                String pathFile = fileContent.getString("data");
                FileBlob blob = (FileBlob)session.getFile(pathFile);
                FileInputStream in = new FileInputStream(blob.getFile());
                File tempFile = File.createTempFile("tempFile2", ".tmp");
                FileOutputStream out = new FileOutputStream(tempFile);
                try {
                    byte[] b = new byte[4096];
                    int i = -1;
                    while ((i = ((InputStream)in).read(b)) != -1) {
                        ((OutputStream)out).write(b, 0, i);
                    }
                    out.flush();
                }
                finally {
                    ((InputStream)in).close();
                    ((OutputStream)out).close();
                }
                blob.getFile().delete();
                CMSBinaryContent content = new CMSBinaryContent();
                content.setName(blob.getFileName());
                content.setFile(tempFile);
                content.setMimeType(blob.getMimeType());
                return content;
            }
        }
        throw new NuxeoException(NuxeoException.ERROR_NOTFOUND);
    }

    public String getId() {
        return "CMSBinaryContentCommand" + this.image + "/" + this.content;
    }
}

