/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.document;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.CMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.document.comments.AddCommentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.comments.CreateChildCommentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.comments.DeleteCommentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.comments.GetCommentsCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.comments.HTMLCommentsTreeBuilder;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import fr.toutatice.portail.cms.nuxeo.portlets.thumbnail.ThumbnailServlet;
import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import net.sf.json.JSONArray;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;

public class ViewDocumentPortlet
extends CMSPortlet {
    private static Log logger = LogFactory.getLog(ViewDocumentPortlet.class);
    private INuxeoService nuxeoService;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        try {
            this.nuxeoService = (INuxeoService)this.getPortletContext().getAttribute("NuxeoService");
            if (this.nuxeoService == null) {
                throw new PortletException("Cannot start ViewDocumentPortlet portlet due to service unavailability");
            }
            CMSCustomizer customizer = new CMSCustomizer(this.getPortletContext());
            this.nuxeoService.registerCMSCustomizer((INuxeoCustomizer)customizer);
            CMSService CMSservice = new CMSService(this.getPortletContext());
            ICMSServiceLocator cmsLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
            cmsLocator.register((ICMSService)CMSservice);
            customizer.setCmsService(CMSservice);
            CMSservice.setCustomizer((DefaultCMSCustomizer)customizer);
            ThumbnailServlet.setPortletContext((PortletContext)this.getPortletContext());
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void processAction(ActionRequest req, ActionResponse res) throws IOException, PortletException {
        block19: {
            String commentAction;
            logger.debug((Object)"processAction ");
            if ("admin".equals(req.getPortletMode().toString()) && req.getParameter("modifierPrefs") != null) {
                PortalWindow window = WindowFactory.getWindow((PortletRequest)req);
                window.setProperty("osivia.cms.uri", req.getParameter("nuxeoPath"));
                if ("1".equals(req.getParameter("onlyDescription"))) {
                    window.setProperty("osivia.document.onlyDescription", "1");
                } else if (window.getProperty("osivia.document.onlyDescription") != null) {
                    window.setProperty("osivia.document.onlyDescription", null);
                }
                if (!"1".equals(req.getParameter("showMetadatas"))) {
                    window.setProperty("osivia.cms.hideMetaDatas", "1");
                } else if (window.getProperty("osivia.cms.hideMetaDatas") != null) {
                    window.setProperty("osivia.cms.hideMetaDatas", null);
                }
                if (req.getParameter("displayLiveVersion") != null && req.getParameter("displayLiveVersion").length() > 0) {
                    window.setProperty("osivia.cms.displayLiveVersion", req.getParameter("displayLiveVersion"));
                } else if (window.getProperty("osivia.cms.displayLiveVersion") != null) {
                    window.setProperty("osivia.cms.displayLiveVersion", null);
                }
                res.setPortletMode(PortletMode.VIEW);
                res.setWindowState(WindowState.NORMAL);
            }
            if ("admin".equals(req.getPortletMode().toString()) && req.getParameter("annuler") != null) {
                res.setPortletMode(PortletMode.VIEW);
                res.setWindowState(WindowState.NORMAL);
            }
            if ((commentAction = req.getParameter("comments")) != null) {
                NuxeoController ctrl = new NuxeoController((PortletRequest)req, (PortletResponse)res, this.getPortletContext());
                PortalWindow window = WindowFactory.getWindow((PortletRequest)req);
                String nuxeoPath = window.getProperty("osivia.cms.uri");
                if (nuxeoPath == null) {
                    nuxeoPath = window.getProperty("osivia.nuxeoPath");
                }
                if (nuxeoPath != null) {
                    nuxeoPath = ctrl.getComputedPath(nuxeoPath);
                    try {
                        String commentId;
                        Document commentableDoc = ctrl.fetchDocument(nuxeoPath);
                        if ("toAdd".equals(commentAction)) {
                            String commentContent = req.getParameter("content");
                            ctrl.executeNuxeoCommand((INuxeoCommand)new AddCommentCommand(commentableDoc, commentContent, null, null));
                        }
                        if ("addChild".equals(req.getParameter("comments"))) {
                            commentId = req.getParameter("commentId");
                            String childCommentContent = req.getParameter("childCommentContent");
                            ctrl.executeNuxeoCommand((INuxeoCommand)new CreateChildCommentCommand(commentableDoc, commentId, childCommentContent, null, null));
                        }
                        if ("delete".equals(commentAction)) {
                            commentId = req.getParameter("commentId");
                            ctrl.executeNuxeoCommand((INuxeoCommand)new DeleteCommentCommand(commentableDoc, commentId));
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof PortletException) break block19;
                        throw new PortletException((Throwable)e);
                    }
                }
            }
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest req, RenderResponse res) throws IOException, PortletException {
        res.setContentType("text/html");
        NuxeoController ctx = new NuxeoController((PortletRequest)req, (PortletResponse)res, this.getPortletContext());
        PortletRequestDispatcher rd = null;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)req);
        String nuxeoPath = window.getProperty("osivia.cms.uri");
        if (nuxeoPath == null) {
            nuxeoPath = "";
        }
        req.setAttribute("nuxeoPath", (Object)nuxeoPath);
        String onlyDescription = window.getProperty("osivia.document.onlyDescription");
        req.setAttribute("onlyDescription", (Object)onlyDescription);
        String showMetadatas = "1";
        if ("1".equals(window.getProperty("osivia.cms.hideMetaDatas"))) {
            showMetadatas = "0";
        }
        req.setAttribute("showMetadatas", (Object)showMetadatas);
        String displayLiveVersion = window.getProperty("osivia.cms.displayLiveVersion");
        req.setAttribute("displayLiveVersion", (Object)displayLiveVersion);
        req.setAttribute("ctx", (Object)ctx);
        rd = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/document/admin.jsp");
        rd.include(req, res);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, PortletSecurityException, IOException {
        block9: {
            logger.debug((Object)"doView");
            try {
                response.setContentType("text/html");
                PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
                String nuxeoPath = null;
                nuxeoPath = window.getProperty("osivia.cms.uri");
                if (nuxeoPath != null) {
                    NuxeoController ctx = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
                    Document doc = ctx.fetchDocument(nuxeoPath = ctx.getComputedPath(nuxeoPath));
                    if (doc.getTitle() != null) {
                        response.setTitle(doc.getTitle());
                    }
                    request.setAttribute("doc", (Object)doc);
                    if (!"1".equals(window.getProperty("osivia.document.onlyDescription")) || request.getWindowState().equals((Object)WindowState.MAXIMIZED)) {
                        String note = doc.getString("note:note", "");
                        ctx.setCurrentDoc(doc);
                        ctx.insertContentMenuBarItems();
                        String noteTransformee = ctx.transformHTMLContent(note);
                        request.setAttribute("note", (Object)noteTransformee);
                        ICMSService cmsService = NuxeoController.getCMSService();
                        CMSPublicationInfos publiInfos = cmsService.getPublicationInfos(ctx.getCMSCtx(), nuxeoPath);
                        boolean docCanBeCommentedByUser = publiInfos.isCommentableByUser();
                        if (docCanBeCommentedByUser) {
                            String user = request.getRemoteUser();
                            int authType = ctx.getAuthType();
                            JSONArray jsonComments = (JSONArray)ctx.executeNuxeoCommand((INuxeoCommand)new GetCommentsCommand(doc));
                            CMSServiceCtx cmsCtx = ctx.getCMSCtx();
                            String comments = HTMLCommentsTreeBuilder.buildHtmlTree((CMSServiceCtx)cmsCtx, (StringBuffer)new StringBuffer(), (JSONArray)jsonComments, (int)0, (int)authType, (String)user);
                            request.setAttribute("comments", (Object)comments);
                        }
                    }
                    request.setAttribute("ctx", (Object)ctx);
                    String description = doc.getString("dc:description", "");
                    request.setAttribute("description", (Object)description);
                    request.setAttribute("onlyDescription", (Object)window.getProperty("osivia.document.onlyDescription"));
                    String showMetadatas = "1";
                    if ("1".equals(window.getProperty("osivia.cms.hideMetaDatas"))) {
                        showMetadatas = "0";
                    }
                    request.setAttribute("showMetadatas", (Object)showMetadatas);
                    this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/document/view.jsp").include(request, response);
                } else {
                    response.setContentType("text/html");
                    response.getWriter().print("<h2>Document non d\u00e9fini</h2>");
                    response.getWriter().close();
                }
            }
            catch (NuxeoException e) {
                PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
            }
            catch (Exception e) {
                if (e instanceof PortletException) break block9;
                throw new PortletException((Throwable)e);
            }
        }
        logger.debug((Object)"doView end");
    }
}

