/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.search;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.portlets.search.SearchCommand;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.Window;
import org.nuxeo.ecm.automation.client.model.PaginableDocuments;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class SearchPortlet
extends CMSPortlet {
    protected IPortalUrlFactory urlFactory;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.urlFactory = (IPortalUrlFactory)this.getPortletContext().getAttribute("UrlService");
    }

    public void processAction(ActionRequest req, ActionResponse res) throws IOException, PortletException {
        if (PortletMode.VIEW.equals((Object)req.getPortletMode()) && req.getParameter("searchAction") != null) {
            res.setRenderParameter("keywords", req.getParameter("keywords"));
        }
        if ("admin".equals(req.getPortletMode().toString()) && req.getParameter("modifierPrefs") != null) {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)req);
            window.setProperty("osivia.cms.uri", req.getParameter("nuxeoPath"));
            if (req.getParameter("displayLiveVersion") != null && req.getParameter("displayLiveVersion").length() > 0) {
                window.setProperty("osivia.cms.displayLiveVersion", req.getParameter("displayLiveVersion"));
            } else if (window.getProperty("osivia.cms.displayLiveVersion") != null) {
                window.setProperty("osivia.cms.displayLiveVersion", null);
            }
            res.setPortletMode(PortletMode.VIEW);
            res.setWindowState(WindowState.NORMAL);
        }
        if ("admin".equals(req.getPortletMode().toString()) && req.getParameter("annuler") != null) {
            res.setPortletMode(PortletMode.VIEW);
            res.setWindowState(WindowState.NORMAL);
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest req, RenderResponse res) throws IOException, PortletException {
        res.setContentType("text/html");
        NuxeoController ctx = new NuxeoController((PortletRequest)req, (PortletResponse)res, this.getPortletContext());
        PortletRequestDispatcher rd = null;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)req);
        String nuxeoPath = window.getProperty("osivia.cms.uri");
        if (nuxeoPath == null) {
            nuxeoPath = "";
        }
        req.setAttribute("nuxeoPath", (Object)nuxeoPath);
        String displayLiveVersion = window.getProperty("osivia.cms.displayLiveVersion");
        req.setAttribute("displayLiveVersion", (Object)displayLiveVersion);
        req.setAttribute("ctx", (Object)ctx);
        rd = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/search/admin.jsp");
        rd.include(req, res);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, PortletSecurityException, IOException {
        block7: {
            NuxeoController ctx = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            String nuxeoPath = window.getProperty("osivia.cms.uri");
            String keywords = request.getParameter("keywords");
            if (keywords == null) {
                keywords = request.getParameter("osivia.keywords");
            }
            try {
                response.setContentType("text/html");
                if (keywords != null) {
                    int currentPage = 0;
                    String sCurrentPage = request.getParameter("currentPage");
                    if (sCurrentPage != null) {
                        currentPage = Integer.parseInt(sCurrentPage);
                    }
                    ctx.setCacheTimeOut(0L);
                    PaginableDocuments docs = (PaginableDocuments)ctx.executeNuxeoCommand((INuxeoCommand)new SearchCommand(nuxeoPath, ctx.isDisplayingLiveVersion(), keywords, currentPage));
                    request.setAttribute("docs", (Object)docs);
                    request.setAttribute("ctx", (Object)ctx);
                    request.setAttribute("keywords", (Object)keywords);
                    request.setAttribute("currentPage", (Object)currentPage);
                    response.setTitle("R\u00e9sultats de la recherche");
                    this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/search/result.jsp").include(request, response);
                } else {
                    Window windowPortal = (Window)request.getAttribute("osivia.window");
                    Page page = (Page)windowPortal.getParent();
                    String pageId = URLEncoder.encode(page.getId().toString(PortalObjectPath.SAFEST_FORMAT), "UTF-8");
                    HashMap<String, String> windowProperties = new HashMap<String, String>();
                    windowProperties.put("osivia.cms.uri", ctx.getComputedPath(nuxeoPath));
                    windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
                    windowProperties.put("osivia.hideSearchSubForm", "1");
                    windowProperties.put("osivia.title", "R\u00e9sultats de la recherche");
                    windowProperties.put("osivia.hideDecorators", "1");
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("keywords", "__REPLACE_KEYWORDS__");
                    String url = this.urlFactory.getStartPortletInRegionUrl(new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response), pageId, "toutatice-portail-cms-nuxeo-searchPortletInstance", "virtual", "portalServiceWindow", windowProperties, params);
                    request.setAttribute("searchUrl", (Object)url);
                    request.setAttribute("ctx", (Object)ctx);
                    this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/search/view.jsp").include(request, response);
                }
            }
            catch (NuxeoException e) {
                PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
            }
            catch (Exception e) {
                if (e instanceof PortletException) break block7;
                throw new PortletException((Throwable)e);
            }
        }
    }
}

