/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.selectors;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PageSelectors;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletSecurityException;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class DateSelectorPortlet
extends CMSPortlet {
    public static String DATES_SEPARATOR = "%";
    private static final String DATE_FROM_SUFFIX = "-date-from";
    private static final String DATE_TO_SUFFIX = "-date-to";
    private static Log logger = LogFactory.getLog(DateSelectorPortlet.class);

    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        logger.debug((Object)"processAction ");
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        if ("admin".equals(request.getPortletMode().toString()) && request.getParameter("modifierPrefs") != null) {
            List dates;
            if (request.getParameter("selectorId").length() > 0) {
                window.setProperty("osivia.selectorId", request.getParameter("selectorId"));
            } else if (window.getProperty("osivia.selectorId") != null) {
                window.setProperty("osivia.selectorId", null);
            }
            if (request.getParameter("libelle").length() > 0) {
                window.setProperty("osivia.libelle", request.getParameter("libelle"));
            } else if (window.getProperty("osivia.libelle") != null) {
                window.setProperty("osivia.libelle", null);
            }
            if ("1".equals(request.getParameter("datesMonoValued"))) {
                window.setProperty("osivia.datesMonoValued", "1");
            } else if (window.getProperty("osivia.datesMonoValued") != null) {
                window.setProperty("osivia.datesMonoValued", null);
            }
            Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
            if (selectors != null && (dates = (List)selectors.get(request.getParameter("selectorId"))) != null && dates.size() > 0) {
                dates.clear();
                response.setRenderParameter("selectors", PageSelectors.encodeProperties((Map)selectors));
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        }
        if ("admin".equals(request.getPortletMode().toString()) && request.getParameter("annuler") != null) {
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        }
        if (PortletMode.VIEW.equals((Object)request.getPortletMode())) {
            String action = request.getParameter("action");
            String selectorId = window.getProperty("osivia.selectorId");
            boolean monoValued = "1".equals(window.getProperty("osivia.datesMonoValued"));
            if ("add".equalsIgnoreCase(action)) {
                this.add(request, response, selectorId, monoValued);
            } else if ("delete".equalsIgnoreCase(action)) {
                this.delete(request, response, selectorId);
            }
        }
    }

    private void add(ActionRequest request, ActionResponse response, String selectorId, boolean monoValued) {
        Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
        ArrayList<String> datesSelector = (ArrayList<String>)selectors.get(selectorId);
        if (datesSelector == null) {
            datesSelector = new ArrayList<String>();
            selectors.put(selectorId, datesSelector);
        }
        if (monoValued) {
            datesSelector.clear();
        }
        String dateFrom = request.getParameter(response.getNamespace() + DATE_FROM_SUFFIX);
        String dateTo = request.getParameter(response.getNamespace() + DATE_TO_SUFFIX);
        boolean validation = true;
        if (StringUtils.isBlank((String)dateFrom)) {
            if (StringUtils.isBlank((String)dateTo)) {
                validation = false;
            } else {
                dateFrom = dateTo;
            }
        } else if (StringUtils.isBlank((String)dateTo)) {
            dateTo = dateFrom;
        }
        if (validation) {
            datesSelector.add(dateFrom + DATES_SEPARATOR + dateTo);
        }
        response.setRenderParameter("selectors", PageSelectors.encodeProperties((Map)selectors));
        request.setAttribute("osivia.unsetMaxMode", (Object)"true");
    }

    private void delete(ActionRequest request, ActionResponse response, String selectorId) {
        int occ = Integer.valueOf(request.getParameter("occ")) - 1;
        Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
        List dateSelectors = (List)selectors.get(selectorId);
        if (dateSelectors != null) {
            dateSelectors.remove(occ);
        }
        response.setRenderParameter("selectors", PageSelectors.encodeProperties((Map)selectors));
        request.setAttribute("osivia.unsetMaxMode", (Object)"true");
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest req, RenderResponse res) throws IOException, PortletException {
        res.setContentType("text/html");
        PortletRequestDispatcher rd = null;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)req);
        String selectorId = window.getProperty("osivia.selectorId");
        if (selectorId == null) {
            selectorId = "";
        }
        req.setAttribute("selectorId", (Object)selectorId);
        String libelle = window.getProperty("osivia.libelle");
        if (libelle == null) {
            libelle = "";
        }
        req.setAttribute("libelle", (Object)libelle);
        String datesMonoValued = window.getProperty("osivia.datesMonoValued");
        if (datesMonoValued == null) {
            datesMonoValued = "0";
        }
        req.setAttribute("datesMonoValued", (Object)datesMonoValued);
        rd = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/selectors/date/admin.jsp");
        rd.include(req, res);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, PortletSecurityException, IOException {
        logger.debug((Object)"doView");
        try {
            response.setContentType("text/html");
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            String selectorId = window.getProperty("osivia.selectorId");
            String libelle = window.getProperty("osivia.libelle");
            request.setAttribute("libelle", (Object)libelle);
            String datesMonoValued = window.getProperty("osivia.datesMonoValued");
            request.setAttribute("datesMonoValued", (Object)datesMonoValued);
            String idDateFrom = response.getNamespace() + DATE_FROM_SUFFIX;
            String dateFrom = request.getParameter(idDateFrom);
            String idDateTo = response.getNamespace() + DATE_TO_SUFFIX;
            String dateTo = request.getParameter(idDateTo);
            if (selectorId != null) {
                Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
                if (selectors.get(selectorId) != null) {
                    request.setAttribute("dates", selectors.get(selectorId));
                } else {
                    request.setAttribute("dates", new ArrayList());
                }
                request.setAttribute(idDateFrom, (Object)dateFrom);
                request.setAttribute(idDateTo, (Object)dateTo);
                this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/selectors/date/view.jsp").include(request, response);
            } else {
                response.getWriter().print("<h2>Identifiant non d\u00e9fini</h2>");
                response.getWriter().close();
            }
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        logger.debug((Object)"doView end");
    }
}

