/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.service;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCommandService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoServiceCommand;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandServiceFactory;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import fr.toutatice.portail.cms.nuxeo.portlets.commands.DocumentFetchPublishedCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.EditableWindowAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.document.DocumentFetchLiveCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.FileContentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.InternalPictureCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.PictureContentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.PutInTrashDocumentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.DocumentGetMediaLibraryCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.DocumentPublishSpaceNavigationCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.ListCMSSubitemsCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.PartialNavigationCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.PartialNavigationInvoker;
import fr.toutatice.portail.cms.nuxeo.portlets.service.PublishInfosCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.DocumentDeleteCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.DocumentRemovePropertyCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.DocumentUpdatePropertiesCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.EditableWindow;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.EditableWindowHelper;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.SetOffLineCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.SetOnLineCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portal.common.invocation.Scope;
import org.jboss.portal.identity.User;
import org.jboss.portal.server.ServerInvocation;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.cache.services.ICacheService;
import org.osivia.portal.api.cache.services.IServiceInvoker;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.core.cms.CMSBinaryContent;
import org.osivia.portal.core.cms.CMSEditableWindow;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSHandlerProperties;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSItemType;
import org.osivia.portal.core.cms.CMSObjectPath;
import org.osivia.portal.core.cms.CMSPage;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.EcmCommand;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.NavigationItem;
import org.osivia.portal.core.page.PageProperties;
import org.osivia.portal.core.profils.IProfilManager;

public class CMSService
implements ICMSService {
    protected static final Log logger = LogFactory.getLog(CMSService.class);
    private final PortletContext portletCtx;
    private INuxeoCommandService nuxeoCommandService;
    private INuxeoService nuxeoService;
    private IProfilManager profilManager;
    private ICacheService serviceCache;
    private DefaultCMSCustomizer customizer;
    private IPortalUrlFactory urlFactory;

    public CMSService(PortletContext portletCtx) {
        this.portletCtx = portletCtx;
    }

    public DefaultCMSCustomizer getCustomizer() {
        return this.customizer;
    }

    public void setCustomizer(DefaultCMSCustomizer customizer) {
        this.customizer = customizer;
    }

    public CMSItem createItem(CMSServiceCtx cmsCtx, String path, String displayName, Document doc) throws CMSException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("displayName", displayName);
        properties.put("type", doc.getType());
        CMSItem cmsItem = new CMSItem(path, properties, (Object)doc);
        CMSItemType type = (CMSItemType)this.customizer.getCMSItemTypes().get(doc.getType());
        cmsItem.setType(type);
        return cmsItem;
    }

    public CMSItem createNavigationItem(CMSServiceCtx cmsCtx, String path, String displayName, Document doc, String publishSpacePath) throws CMSException {
        CMSItem cmsItem = this.createItem(cmsCtx, path, displayName, doc);
        CMSItem publishSpaceItem = null;
        publishSpaceItem = publishSpacePath != null && !path.equals(publishSpacePath) ? this.getPortalNavigationItem(cmsCtx, publishSpacePath, publishSpacePath) : cmsItem;
        this.getCustomizer().getNavigationItemAdapter().adaptPublishSpaceNavigationItem(cmsItem, publishSpaceItem);
        return cmsItem;
    }

    public List<CMSItem> getChildren(CMSServiceCtx ctx, String path) throws CMSException {
        return new ArrayList<CMSItem>();
    }

    public IProfilManager getProfilManager() throws Exception {
        if (this.profilManager == null) {
            this.profilManager = (IProfilManager)this.portletCtx.getAttribute("ProfileService");
        }
        return this.profilManager;
    }

    public INuxeoService getNuxeoService() throws Exception {
        if (this.nuxeoService == null) {
            this.nuxeoService = (INuxeoService)this.portletCtx.getAttribute("NuxeoService");
        }
        return this.nuxeoService;
    }

    public ICacheService getCacheService() throws Exception {
        if (this.serviceCache == null) {
            this.serviceCache = (ICacheService)this.portletCtx.getAttribute("CacheService");
        }
        return this.serviceCache;
    }

    public INuxeoCommandService getNuxeoCommandService() throws Exception {
        if (this.nuxeoCommandService == null) {
            this.nuxeoCommandService = NuxeoCommandServiceFactory.getNuxeoCommandService((PortletContext)this.portletCtx);
        }
        return this.nuxeoCommandService;
    }

    public IPortalUrlFactory getPortalUrlFactory() {
        if (this.urlFactory == null) {
            this.urlFactory = (IPortalUrlFactory)this.portletCtx.getAttribute("UrlService");
        }
        return this.urlFactory;
    }

    public Object executeNuxeoCommand(CMSServiceCtx cmsCtx, INuxeoCommand command) throws Exception {
        NuxeoCommandContext commandCtx = new NuxeoCommandContext(this.portletCtx, cmsCtx.getServerInvocation());
        commandCtx.setAsyncCacheRefreshing(cmsCtx.isAsyncCacheRefreshing());
        if (cmsCtx.isForceReload()) {
            commandCtx.setForceReload(true);
        }
        String scope = cmsCtx.getScope();
        commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_USER);
        commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        if (scope != null && !"__nocache".equals(scope)) {
            if ("user_session".equals(scope)) {
                commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_USER);
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_SESSION);
            } else if ("anonymous".equals(scope)) {
                commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_ANONYMOUS);
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
            } else if ("superuser_context".equals(scope)) {
                commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
            } else if ("superuser_no_cache".equals(scope)) {
                commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
            } else {
                commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_PROFIL);
                commandCtx.setAuthProfil(this.getProfilManager().getProfil(scope));
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
            }
        }
        return this.getNuxeoCommandService().executeCommand(commandCtx, (INuxeoServiceCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMSItem fetchContent(CMSServiceCtx cmsCtx, String path) throws Exception {
        String savedScope = cmsCtx.getScope();
        try {
            boolean saveAsync = cmsCtx.isAsyncCacheRefreshing();
            cmsCtx.setAsyncCacheRefreshing(false);
            CMSPublicationInfos pubInfos = this.getPublicationInfos(cmsCtx, path);
            cmsCtx.setAsyncCacheRefreshing(saveAsync);
            boolean haveToGetLive = "1".equals(cmsCtx.getDisplayLiveVersion());
            if ("1".equals(cmsCtx.getPreviewVersion())) {
                haveToGetLive = true;
            }
            if (!pubInfos.isPublished() && StringUtils.isNotEmpty((String)pubInfos.getPublishSpacePath()) && pubInfos.isLiveSpace()) {
                haveToGetLive = true;
            }
            if (!pubInfos.isPublished() && pubInfos.getPublishSpacePath() == null) {
                haveToGetLive = true;
            }
            cmsCtx.setScope("superuser_context");
            if (haveToGetLive) {
                Document doc = (Document)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentFetchLiveCommand(path, "Read"));
                CMSItem cMSItem = this.createItem(cmsCtx, path, doc.getTitle(), doc);
                return cMSItem;
            }
            Document doc = (Document)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentFetchPublishedCommand(path));
            CMSItem cMSItem = this.createItem(cmsCtx, path, doc.getTitle(), doc);
            return cMSItem;
        }
        finally {
            cmsCtx.setScope(savedScope);
        }
    }

    public CMSItem getContent(CMSServiceCtx cmsCtx, String path) throws CMSException {
        CMSItem content = null;
        try {
            content = this.fetchContent(cmsCtx, path);
            this.getCustomizer().getCMSItemAdapter().adaptItem(cmsCtx, content);
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return content;
    }

    public CMSBinaryContent getBinaryContent(CMSServiceCtx cmsCtx, String type, String docPath, String parameter) throws CMSException {
        CMSBinaryContent content = new CMSBinaryContent();
        if ("file".equals(type)) {
            content = this.getFileContent(cmsCtx, docPath, parameter);
        } else if ("attachedPicture".equals(type)) {
            content = this.getAttachedPicture(cmsCtx, docPath, parameter);
        } else if ("picture".equals(type)) {
            content = this.getPicture(cmsCtx, docPath, parameter);
        }
        return content;
    }

    public CMSBinaryContent getAttachedPicture(CMSServiceCtx cmsCtx, String docPath, String pictureIndex) throws CMSException {
        CMSBinaryContent cmsContent = null;
        try {
            cmsContent = this.fetchAttachedPicture(cmsCtx, docPath, pictureIndex);
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return cmsContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMSBinaryContent fetchAttachedPicture(CMSServiceCtx cmsCtx, String docPath, String pictureIndex) throws Exception {
        CMSBinaryContent pictureContent = null;
        String savedScope = cmsCtx.getScope();
        try {
            CMSItem containerDoc = this.fetchContent(cmsCtx, docPath);
            if (containerDoc != null) {
                cmsCtx.setScope("superuser_context");
                pictureContent = (CMSBinaryContent)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new InternalPictureCommand((Document)containerDoc.getNativeItem(), pictureIndex));
            }
        }
        finally {
            cmsCtx.setScope(savedScope);
        }
        return pictureContent;
    }

    public CMSBinaryContent getPicture(CMSServiceCtx cmsCtx, String docPath, String content) throws CMSException {
        CMSBinaryContent cmsContent = null;
        try {
            cmsContent = this.fetchPicture(cmsCtx, docPath, content);
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return cmsContent;
    }

    private CMSBinaryContent fetchPicture(CMSServiceCtx cmsCtx, String docPath, String content) throws Exception {
        CMSBinaryContent pictureContent = null;
        String savedScope = cmsCtx.getScope();
        String savedPubInfosScope = cmsCtx.getForcePublicationInfosScope();
        try {
            cmsCtx.setForcePublicationInfosScope("superuser_context");
            CMSPublicationInfos publiInfos = this.getPublicationInfos(cmsCtx, docPath);
            cmsCtx.setForcePublicationInfosScope(null);
            if (publiInfos.isAnonymouslyReadable()) {
                cmsCtx.setForcePublicationInfosScope("anonymous");
            }
            CMSItem picture = this.fetchContent(cmsCtx, docPath);
            cmsCtx.setScope("superuser_context");
            pictureContent = (CMSBinaryContent)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new PictureContentCommand((Document)picture.getNativeItem(), content));
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                if (e instanceof NuxeoException && ((NuxeoException)((Object)e)).getErrorCode() == NuxeoException.ERROR_NOTFOUND) {
                    CMSBinaryContent cMSBinaryContent = null;
                    return cMSBinaryContent;
                }
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        finally {
            cmsCtx.setScope(savedScope);
            cmsCtx.setForcePublicationInfosScope(savedPubInfosScope);
        }
        return pictureContent;
    }

    public CMSBinaryContent getFileContent(CMSServiceCtx cmsCtx, String docPath, String fieldName) throws CMSException {
        CMSBinaryContent cmsContent = null;
        try {
            cmsContent = this.fetchFileContent(cmsCtx, docPath, fieldName);
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return cmsContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMSBinaryContent fetchFileContent(CMSServiceCtx cmsCtx, String docPath, String fieldName) throws Exception {
        CMSBinaryContent content = null;
        String savedScope = cmsCtx.getScope();
        try {
            CMSItem document;
            if (StringUtils.isNotEmpty((String)savedScope)) {
                cmsCtx.setForcePublicationInfosScope(savedScope);
            }
            if ((document = this.fetchContent(cmsCtx, docPath)) != null) {
                String size;
                PropertyMap map;
                cmsCtx.setScope("superuser_context");
                FileContentCommand cmd = new FileContentCommand((Document)document.getNativeItem(), fieldName);
                if (cmsCtx.isStreamingSupport() && (map = ((Document)document.getNativeItem()).getProperties().getMap("file:content")) != null && !map.isEmpty() && (size = map.getString("length")) != null && Long.parseLong(size) > 1000000L) {
                    cmd.setStreamingSupport(true);
                    cmsCtx.setScope("superuser_no_cache");
                }
                content = (CMSBinaryContent)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)cmd);
            }
        }
        finally {
            cmsCtx.setScope(savedScope);
        }
        return content;
    }

    public boolean checkContentAnonymousAccess(CMSServiceCtx cmsCtx, String path) throws CMSException {
        try {
            CMSPublicationInfos pubInfos = this.getPublicationInfos(cmsCtx, path);
            return pubInfos.isAnonymouslyReadable();
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return false;
    }

    public CMSHandlerProperties getItemHandler(CMSServiceCtx ctx) throws CMSException {
        try {
            if (!"detailedView".equals(ctx.getDisplayContext())) {
                return this.getNuxeoService().getCMSCustomizer().getCMSPlayer(ctx);
            }
            return ((DefaultCMSCustomizer)this.getNuxeoService().getCMSCustomizer()).getCMSDefaultPlayer(ctx);
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return null;
    }

    public Map<String, NavigationItem> loadPartialNavigationTree(CMSServiceCtx cmsCtx, CMSItem publishSpaceConfig, String path, boolean fetchSubItems) throws CMSException {
        String savedScope = cmsCtx.getScope();
        try {
            Map<String, Object> navItems = null;
            ArrayList<String> idsToFetch = new ArrayList<String>();
            boolean fetchRoot = false;
            String cacheId = "partial_navigation_tree/" + publishSpaceConfig.getPath();
            HttpServletRequest request = cmsCtx.getServerInvocation().getServerContext().getClientRequest();
            boolean refreshing = PageProperties.getProperties().isRefreshingPage();
            PartialNavigationInvoker partialNavInvoker = null;
            if (refreshing) {
                partialNavInvoker = (PartialNavigationInvoker)request.getAttribute("partialNavInvoker");
            }
            CacheInfo cacheInfos = new CacheInfo(cacheId, CacheInfo.CACHE_SCOPE_PORTLET_SESSION, null, (Object)request, this.portletCtx, false);
            cacheInfos.setExpirationDelay(200000L);
            navItems = (HashMap<String, NavigationItem>)this.getCacheService().getCache(cacheInfos);
            if (navItems == null) {
                navItems = new HashMap<String, NavigationItem>();
                fetchRoot = true;
            }
            String pathToCheck = path;
            CMSServiceCtx superUserCtx = new CMSServiceCtx();
            superUserCtx.setControllerContext(cmsCtx.getControllerContext());
            cmsCtx.setScope("superuser_context");
            do {
                Document doc;
                Document doc2;
                NavigationItem navItem;
                if ((navItem = (NavigationItem)navItems.get(pathToCheck)) != null && fetchSubItems && navItem.isUnfetchedChildren() && !idsToFetch.contains((doc2 = (Document)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentFetchLiveCommand(pathToCheck, "Read"))).getId())) {
                    idsToFetch.add(doc2.getId());
                }
                CMSObjectPath parentPath = CMSObjectPath.parse((String)pathToCheck).getParent();
                pathToCheck = parentPath.toString();
                if (navItem != null || idsToFetch.contains((doc = (Document)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentFetchLiveCommand(pathToCheck, "Read"))).getId())) continue;
                idsToFetch.add(doc.getId());
            } while (pathToCheck.contains(publishSpaceConfig.getPath()));
            if (idsToFetch.size() > 0 || fetchRoot) {
                cmsCtx.setScope("__nocache");
                navItems = (Map)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new PartialNavigationCommand(publishSpaceConfig, navItems, idsToFetch, fetchRoot, path));
                cacheInfos.setForceReload(true);
                cacheInfos.setForceNOTReload(false);
                partialNavInvoker = new PartialNavigationInvoker(navItems);
                if (refreshing) {
                    request.setAttribute("partialNavInvoker", (Object)partialNavInvoker);
                }
                cacheInfos.setInvoker((IServiceInvoker)partialNavInvoker);
                this.getCacheService().getCache(cacheInfos);
            }
            HashMap<String, NavigationItem> hashMap = navItems;
            return hashMap;
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        finally {
            cmsCtx.setScope(savedScope);
        }
    }

    public CMSItem getPortalNavigationItem(CMSServiceCtx cmsCtx, String publishSpacePath, String path) throws CMSException {
        String savedScope = cmsCtx.getScope();
        if (cmsCtx.getScope() == null || "__nocache".equals(cmsCtx.getScope())) {
            cmsCtx.setScope("user_session");
        }
        try {
            NavigationItem navItem;
            String livePath = DocumentPublishSpaceNavigationCommand.computeNavPath((String)path);
            CMSItem publishSpaceConfig = this.getSpaceConfig(cmsCtx, publishSpacePath);
            if (publishSpaceConfig == null) {
                throw new CMSException(CMSException.ERROR_NOTFOUND);
            }
            Map navItems = null;
            if ("1".equals(publishSpaceConfig.getProperties().get("partialLoading"))) {
                navItems = this.loadPartialNavigationTree(cmsCtx, publishSpaceConfig, path, false);
            } else {
                boolean forceLiveVersion = false;
                if ("1".equals(cmsCtx.getDisplayLiveVersion())) {
                    forceLiveVersion = true;
                }
                navItems = (Map)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentPublishSpaceNavigationCommand(publishSpaceConfig, forceLiveVersion));
            }
            if (navItems != null && (navItem = (NavigationItem)navItems.get(livePath)) != null) {
                CMSItem item = navItem.getAdaptedCMSItem();
                if (item == null) {
                    if (navItem.getMainDoc() != null) {
                        navItem.setAdaptedCMSItem(this.createNavigationItem(cmsCtx, livePath, ((Document)navItem.getMainDoc()).getTitle(), (Document)navItem.getMainDoc(), publishSpacePath));
                    } else {
                        CMSItem cMSItem = null;
                        return cMSItem;
                    }
                }
                CMSItem cMSItem = navItem.getAdaptedCMSItem();
                return cMSItem;
            }
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        finally {
            cmsCtx.setScope(savedScope);
        }
        return null;
    }

    public List<CMSItem> getPortalNavigationSubitems(CMSServiceCtx cmsCtx, String publishSpacePath, String path) throws CMSException {
        String savedScope = cmsCtx.getScope();
        if (cmsCtx.getScope() == null || "__nocache".equals(cmsCtx.getScope())) {
            cmsCtx.setScope("user_session");
        }
        try {
            NavigationItem navItem;
            CMSItem publishSpaceConfig = this.getSpaceConfig(cmsCtx, publishSpacePath);
            if (publishSpaceConfig == null) {
                throw new CMSException(CMSException.ERROR_NOTFOUND);
            }
            Map navItems = null;
            if ("1".equals(publishSpaceConfig.getProperties().get("partialLoading"))) {
                navItems = this.loadPartialNavigationTree(cmsCtx, publishSpaceConfig, path, true);
            } else {
                boolean forceLiveVersion = false;
                if ("1".equals(cmsCtx.getDisplayLiveVersion())) {
                    forceLiveVersion = true;
                }
                navItems = (Map)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentPublishSpaceNavigationCommand(publishSpaceConfig, forceLiveVersion));
            }
            if (navItems != null && (navItem = (NavigationItem)navItems.get(path)) != null) {
                ArrayList<CMSItem> childrens = new ArrayList<CMSItem>();
                for (Object child : navItem.getChildren()) {
                    Document docChild = (Document)child;
                    String childNavPath = DocumentPublishSpaceNavigationCommand.computeNavPath((String)docChild.getPath());
                    NavigationItem navChild = (NavigationItem)navItems.get(childNavPath);
                    CMSItem item = navChild.getAdaptedCMSItem();
                    if (item == null && navChild.getMainDoc() != null) {
                        navChild.setAdaptedCMSItem(this.createNavigationItem(cmsCtx, childNavPath, ((Document)navChild.getMainDoc()).getTitle(), (Document)navChild.getMainDoc(), publishSpacePath));
                    }
                    childrens.add(navChild.getAdaptedCMSItem());
                }
                ArrayList<CMSItem> arrayList = childrens;
                return arrayList;
            }
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        finally {
            cmsCtx.setScope(savedScope);
        }
        return null;
    }

    public List<CMSItem> getPortalSubitems(CMSServiceCtx cmsContext, String path) throws CMSException {
        try {
            Document parent = (Document)this.fetchContent(cmsContext, path).getNativeItem();
            String parentId = parent.getId();
            boolean liveContent = "1".equals(cmsContext.getDisplayLiveVersion());
            ListCMSSubitemsCommand nuxeoCommand = new ListCMSSubitemsCommand(parentId, liveContent);
            JSONArray documentsWithPublishingInfos = (JSONArray)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)nuxeoCommand);
            ArrayList<CMSItem> cmsItems = new ArrayList<CMSItem>(documentsWithPublishingInfos.size());
            for (JSONObject documentWithPublishingStatus : documentsWithPublishingInfos) {
                String documentId = (String)documentWithPublishingStatus.get("docId");
                String documentPath = (String)documentWithPublishingStatus.get("docPath");
                String documentType = (String)documentWithPublishingStatus.get("docType");
                String documentTitle = (String)documentWithPublishingStatus.get("docTitle");
                PropertyMap nxProperties = new PropertyMap();
                nxProperties.set("dc:title", documentTitle);
                Document poorDocument = new Document(documentId, documentType, null, null, documentPath, null, null, null, null, null, nxProperties, null);
                CMSItem cmsItem = this.createItem(cmsContext, poorDocument.getPath(), poorDocument.getTitle(), poorDocument);
                boolean isPublished = documentWithPublishingStatus.getBoolean("isPublished");
                boolean isLiveModifiedFromProxy = documentWithPublishingStatus.getBoolean("isLiveModifiedFromProxy");
                cmsItem.setPublished(Boolean.valueOf(isPublished));
                cmsItem.setBeingModified(Boolean.valueOf(isLiveModifiedFromProxy));
                boolean isFolderish = documentWithPublishingStatus.getBoolean("isFolderish");
                CMSItemType cmsItemType = new CMSItemType(documentType, isFolderish, false, false, false, false, null, null);
                cmsItem.setType(cmsItemType);
                cmsItems.add(cmsItem);
            }
            return cmsItems;
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMSPublicationInfos getPublicationInfos(CMSServiceCtx ctx, String path) throws CMSException {
        CMSPublicationInfos pubInfos = new CMSPublicationInfos();
        try {
            String savedScope = ctx.getScope();
            try {
                List errors;
                if (StringUtils.isNotEmpty((String)ctx.getForcePublicationInfosScope())) {
                    ctx.setScope(ctx.getForcePublicationInfosScope());
                } else {
                    ServerInvocation invocation = ctx.getServerInvocation();
                    User user = (User)invocation.getAttribute(Scope.PRINCIPAL_SCOPE, (Object)"user");
                    if (user == null) {
                        ctx.setScope("anonymous");
                    } else {
                        ctx.setScope("user_session");
                    }
                }
                pubInfos = (CMSPublicationInfos)this.executeNuxeoCommand(ctx, (INuxeoCommand)new PublishInfosCommand(path));
                if (pubInfos != null && (errors = pubInfos.getErrorCodes()) != null) {
                    if (errors.contains(2)) {
                        throw new CMSException(CMSException.ERROR_FORBIDDEN);
                    }
                    if (errors.contains(1)) {
                        throw new CMSException(CMSException.ERROR_NOTFOUND);
                    }
                }
            }
            finally {
                ctx.setScope(savedScope);
            }
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return pubInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMSItem getSpaceConfig(CMSServiceCtx cmsCtx, String publishSpacePath) throws CMSException {
        CMSItem configItem = null;
        try {
            String savedScope = cmsCtx.getScope();
            String savedPubInfosScope = cmsCtx.getForcePublicationInfosScope();
            try {
                cmsCtx.setAsyncCacheRefreshing(true);
                cmsCtx.setForcePublicationInfosScope("superuser_context");
                configItem = this.fetchContent(cmsCtx, publishSpacePath);
                this.getCustomizer().getNavigationItemAdapter().adaptPublishSpaceNavigationItem(configItem, configItem);
            }
            finally {
                cmsCtx.setScope(savedScope);
                cmsCtx.setAsyncCacheRefreshing(false);
                cmsCtx.setForcePublicationInfosScope(savedPubInfosScope);
            }
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                if (e instanceof NuxeoException && ((NuxeoException)((Object)e)).getErrorCode() == NuxeoException.ERROR_NOTFOUND) {
                    return null;
                }
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return configItem;
    }

    public Map<String, String> parseCMSURL(CMSServiceCtx cmsCtx, String requestPath, Map<String, String> requestParameters) throws CMSException {
        try {
            return this.customizer.parseCMSURL(cmsCtx, requestPath, requestParameters);
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                if (e instanceof NuxeoException && ((NuxeoException)((Object)e)).getErrorCode() == NuxeoException.ERROR_NOTFOUND) {
                    return null;
                }
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
    }

    public String adaptCMSPathToWeb(CMSServiceCtx cmsCtx, String basePath, String requestPath, boolean webPath) throws CMSException {
        try {
            return this.customizer.adaptCMSPathToWeb(cmsCtx, basePath, requestPath, webPath);
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                if (e instanceof NuxeoException && ((NuxeoException)((Object)e)).getErrorCode() == NuxeoException.ERROR_NOTFOUND) {
                    return null;
                }
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
    }

    public List<CMSPage> computeUserPreloadedPages(CMSServiceCtx cmsCtx) throws CMSException {
        try {
            return this.customizer.computeUserPreloadedPages(cmsCtx);
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                if (e instanceof NuxeoException && ((NuxeoException)((Object)e)).getErrorCode() == NuxeoException.ERROR_NOTFOUND) {
                    return null;
                }
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
    }

    public List<CMSEditableWindow> getEditableWindows(CMSServiceCtx cmsCtx, String pagePath) throws CMSException {
        try {
            Document doc;
            PropertyList pmFragmentsValues;
            CMSItem pageItem = this.fetchContent(cmsCtx, pagePath);
            ArrayList<CMSEditableWindow> windows = new ArrayList<CMSEditableWindow>();
            boolean editionMode = false;
            if ("1".equals(cmsCtx.getDisplayLiveVersion())) {
                editionMode = true;
            }
            if ((pmFragmentsValues = (doc = (Document)pageItem.getNativeItem()).getProperties().getList(EditableWindowHelper.SCHEMA)) != null && !pmFragmentsValues.isEmpty()) {
                EditableWindowAdapter adapter = this.customizer.getEditableWindowAdapter();
                for (int fragmentIndex = 0; fragmentIndex < pmFragmentsValues.size(); ++fragmentIndex) {
                    String fragmentCategory = (String)pmFragmentsValues.getMap(fragmentIndex).get(EditableWindowHelper.FGT_TYPE);
                    String uri = (String)pmFragmentsValues.getMap(fragmentIndex).get(EditableWindowHelper.FGT_URI);
                    EditableWindow ew = adapter.getType(fragmentCategory);
                    if (ew != null) {
                        Map props = ew.fillProps(doc, pmFragmentsValues.getMap(fragmentIndex), Boolean.valueOf(editionMode));
                        windows.add(ew.createNewEditabletWindow(fragmentIndex, props));
                        continue;
                    }
                    logger.warn((Object)("Type de fragment " + fragmentCategory + " non g\u00e9r\u00e9"));
                }
            }
            return windows;
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
    }

    public void deleteFragment(CMSServiceCtx cmsCtx, String pagePath, String refURI) throws CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        Document doc = (Document)cmsItem.getNativeItem();
        PropertyList fragments = doc.getProperties().getList(EditableWindowHelper.SCHEMA);
        List propertiesToRemove = null;
        if (fragments != null && !fragments.isEmpty()) {
            for (int fragmentIndex = 0; fragmentIndex < fragments.size(); ++fragmentIndex) {
                if (!refURI.equals(fragments.getMap(fragmentIndex).get(EditableWindowHelper.FGT_URI))) continue;
                String fragmentCategory = (String)fragments.getMap(fragmentIndex).get(EditableWindowHelper.FGT_TYPE);
                EditableWindowAdapter adapter = this.customizer.getEditableWindowAdapter();
                EditableWindow ew = adapter.getType(fragmentCategory);
                if (ew == null) continue;
                propertiesToRemove = ew.prepareDelete(doc, refURI);
            }
        }
        try {
            if (propertiesToRemove != null) {
                Document docSaved = (Document)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentRemovePropertyCommand(doc, propertiesToRemove));
                cmsCtx.setForceReload(true);
                this.getContent(cmsCtx, pagePath);
                cmsCtx.setForceReload(false);
            }
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public String getEcmDomain(CMSServiceCtx cmsCtx) {
        return NuxeoConnectionProperties.getPublicDomainUri().toString();
    }

    public String getEcmUrl(CMSServiceCtx cmsCtx, EcmCommand command, String path, Map<String, String> requestParameters) throws CMSException {
        String uri = NuxeoConnectionProperties.getPublicBaseUri().toString();
        String url = "";
        if (command == EcmCommand.createPage) {
            url = uri.toString() + "/nxpath/default" + path + "@osivia_create_document?";
            requestParameters.put("type", "PortalPage");
        } else if (command == EcmCommand.editPage) {
            url = uri.toString() + "/nxpath/default" + path + "@osivia_edit_document?";
        } else if (command == EcmCommand.createFgtInRegion) {
            url = uri.toString() + "/nxpath/default" + path + "@osivia_create_fragment?";
        } else if (command == EcmCommand.createFgtBelowWindow) {
            url = uri.toString() + "/nxpath/default" + path + "@osivia_create_fragment?";
        } else if (command == EcmCommand.editFgt) {
            url = uri.toString() + "/nxpath/default" + path + "@osivia_edit_fragment?";
        } else if (command == EcmCommand.viewSummary) {
            url = uri.toString() + "/nxpath/default" + path + "@view_documents?";
        } else if (command == EcmCommand.gotoMediaLibrary) {
            Document mediaLibrary;
            try {
                String baseDomainPath = "/".concat(path.split("/")[1]);
                mediaLibrary = (Document)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentGetMediaLibraryCommand(baseDomainPath));
            }
            catch (Exception e) {
                throw new CMSException((Throwable)e);
            }
            url = mediaLibrary != null ? uri.toString() + "/nxpath/default" + mediaLibrary.getPath() + "@view_documents?" : "";
        }
        if (command != EcmCommand.gotoMediaLibrary) {
            PortalControllerContext portalControllerContext = new PortalControllerContext((Object)cmsCtx.getControllerContext());
            String portalUrl = this.getPortalUrlFactory().getBasePortalUrl(portalControllerContext);
            requestParameters.put("fromUrl", portalUrl);
            for (Map.Entry<String, String> param : requestParameters.entrySet()) {
                url = url.concat(param.getKey()).concat("=").concat(param.getValue()).concat("&");
            }
        }
        return url;
    }

    public void moveFragment(CMSServiceCtx cmsCtx, String pagePath, String fromRegion, Integer fromPos, String toRegion, Integer toPos, String refUri) throws CMSException {
        cmsCtx.setForceReload(true);
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        Document doc = (Document)cmsItem.getNativeItem();
        try {
            CMSItem content;
            List propertiesToUpdate = EditableWindowHelper.checkBeforeMove((Document)doc, (String)fromRegion, (Integer)fromPos, (String)refUri);
            if (propertiesToUpdate.size() > 0) {
                this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentUpdatePropertiesCommand(doc, propertiesToUpdate));
                content = this.getContent(cmsCtx, pagePath);
                doc = (Document)content.getNativeItem();
            }
            if ((propertiesToUpdate = EditableWindowHelper.prepareMove((Document)doc, (String)fromRegion, (Integer)fromPos, (String)toRegion, (Integer)toPos, (String)refUri)).size() > 0) {
                this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentUpdatePropertiesCommand(doc, propertiesToUpdate));
                content = this.getContent(cmsCtx, pagePath);
                Document docReloaded = (Document)content.getNativeItem();
            }
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
        finally {
            cmsCtx.setForceReload(false);
        }
    }

    public boolean isCmsWebPage(CMSServiceCtx cmsCtx, String cmsPath) throws CMSException {
        CMSItem content = this.getContent(cmsCtx, cmsPath);
        Document nativeItem = (Document)content.getNativeItem();
        PropertyList list = nativeItem.getProperties().getList(EditableWindowHelper.SCHEMA);
        return list != null;
    }

    public void publishDocument(CMSServiceCtx cmsCtx, String pagePath) throws CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        Document doc = (Document)cmsItem.getNativeItem();
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new SetOnLineCommand(doc));
            cmsCtx.setDisplayLiveVersion("0");
            cmsCtx.setForceReload(true);
            this.getContent(cmsCtx, pagePath);
            cmsCtx.setForceReload(false);
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public void unpublishDocument(CMSServiceCtx cmsCtx, String pagePath) throws CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        Document doc = (Document)cmsItem.getNativeItem();
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new SetOffLineCommand(doc));
            cmsCtx.setForceReload(true);
            this.getContent(cmsCtx, pagePath);
            cmsCtx.setForceReload(false);
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public void deleteDocument(CMSServiceCtx cmsCtx, String pagePath) throws CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        Document doc = (Document)cmsItem.getNativeItem();
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentDeleteCommand(doc));
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public void putDocumentInTrash(CMSServiceCtx cmsCtx, String docId) throws CMSException {
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new PutInTrashDocumentCommand(docId));
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }
}

