/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.service.editablewindow;

import fr.toutatice.portail.cms.nuxeo.service.editablewindow.EditableWindowHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.core.cms.CMSEditableWindow;

public abstract class EditableWindow {
    protected static final Log logger = LogFactory.getLog(EditableWindow.class);
    private String instancePortlet;
    private String prefixWindow;

    public EditableWindow(String instancePortlet, String prefixWindow) {
        this.instancePortlet = instancePortlet;
        this.prefixWindow = prefixWindow;
    }

    public String getInstancePortlet() {
        return this.instancePortlet;
    }

    public void setInstancePortlet(String instancePortlet) {
        this.instancePortlet = instancePortlet;
    }

    public String getPrefixWindow() {
        return this.prefixWindow;
    }

    public abstract Map<String, String> fillProps(Document var1, PropertyMap var2, Boolean var3);

    protected Map<String, String> fillGenericProps(Document doc, PropertyMap fragment, Boolean modeEditionPage) {
        HashMap<String, String> propsFilled = new HashMap<String, String>();
        propsFilled.put("osivia.fragmentTypeId", "html_property");
        propsFilled.put("osivia.propertyName", "htmlfgt:htmlFragment");
        propsFilled.put("osivia.refURI", fragment.getString(EditableWindowHelper.FGT_URI));
        propsFilled.put("osivia.title", fragment.getString("title"));
        propsFilled.put("osivia.style", fragment.getString("style"));
        propsFilled.put("osivia.ajaxLink", "1");
        propsFilled.put("osivia.hideDecorators", "1");
        if (fragment.getBoolean("hideTitle").equals(Boolean.TRUE)) {
            propsFilled.put("osivia.hideTitle", "1");
        } else {
            propsFilled.put("osivia.hideTitle", "0");
        }
        if (modeEditionPage.booleanValue()) {
            propsFilled.put("osivia.cms.displayLiveVersion", "1");
        }
        propsFilled.put("theme.region", fragment.getString("regionId"));
        propsFilled.put("theme.order", fragment.getString("order"));
        return propsFilled;
    }

    protected void prepareDeleteGeneric(List<String> propertiesToRemove, Document doc, String refURI) {
        Integer indexToRemove = EditableWindowHelper.findIndexByURI((Document)doc, (String)refURI);
        propertiesToRemove.add(EditableWindowHelper.SCHEMA.concat("/").concat(indexToRemove.toString()));
    }

    public abstract List<String> prepareDelete(Document var1, String var2);

    public CMSEditableWindow createNewEditabletWindow(int id, Map<String, String> portletProps) {
        String windowId = this.prefixWindow.concat(Integer.toString(id));
        return new CMSEditableWindow(windowId, this.instancePortlet, portletProps);
    }
}

