/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.binaries;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.ResourceUtil;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.core.cms.BinaryDelegation;
import org.osivia.portal.core.cms.BinaryDescription;
import org.osivia.portal.core.cms.CMSBinaryContent;
import org.osivia.portal.core.page.PageProperties;

/*
 * Exception performing whole class analysis ignored.
 */
public class BinaryServlet
extends HttpServlet {
    protected static Log logger = LogFactory.getLog(BinaryServlet.class);
    private static final long serialVersionUID = -8877737456357488020L;
    private static PortletContext portletCtx;
    private static long BINARY_TIMEOUT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamBigFile(InputStream inputStream, OutputStream outputStream, int bufSize) throws IOException {
        try {
            byte[] b = new byte[bufSize];
            int bytesread = 0;
            int bytesBuffered = 0;
            while ((bytesread = inputStream.read(b)) != -1) {
                outputStream.write(b, 0, bytesread);
                if ((bytesBuffered += bytesread) <= 0x100000) continue;
                bytesBuffered = 0;
            }
            outputStream.flush();
        }
        finally {
            inputStream.close();
        }
    }

    public static void setPortletContext(PortletContext documentPortletCtx) {
        portletCtx = documentPortletCtx;
    }

    public String formatResourceLastModified() {
        SimpleDateFormat inputFormater = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        inputFormater.setTimeZone(TimeZone.getTimeZone("GMT"));
        return inputFormater.format(new Date(System.currentTimeMillis()));
    }

    public boolean isResourceExpired(String sOriginalDate) {
        boolean isExpired = true;
        if (sOriginalDate != null) {
            SimpleDateFormat inputFormater = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
            inputFormater.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                Date originalDate = inputFormater.parse(sOriginalDate);
                if (System.currentTimeMillis() < originalDate.getTime() + BINARY_TIMEOUT * 1000L) {
                    isExpired = false;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return isExpired;
    }

    public boolean serveResourceByCache(HttpServletRequest resourceRequest, HttpServletResponse resourceResponse) throws PortletException, IOException {
        String sOriginalDate = resourceRequest.getHeader("if-modified-since");
        if (sOriginalDate == null) {
            sOriginalDate = resourceRequest.getHeader("If-Modified-Since");
        }
        if (!this.isResourceExpired(sOriginalDate)) {
            resourceResponse.sendError(304);
            resourceResponse.setHeader("Last-Modified", sOriginalDate);
            return true;
        }
        return false;
    }

    public void doGet(HttpServletRequest theRequest, HttpServletResponse theResponse) throws IOException, ServletException {
        PageProperties.getProperties().init();
        String portalName = theRequest.getParameter("portalName");
        if (portalName == null) {
            portalName = "default";
        }
        PageProperties.getProperties().getPagePropertiesMap().put("portalName", portalName);
        ServletOutputStream output = theResponse.getOutputStream();
        try {
            if (this.serveResourceByCache(theRequest, theResponse)) {
                return;
            }
            String docPath = theRequest.getParameter("path");
            docPath = URLDecoder.decode(docPath, "UTF-8");
            NuxeoController ctx = new NuxeoController(portletCtx);
            ctx.setServletRequest(theRequest);
            BinaryDelegation delegation = NuxeoController.getCMSService().validateBinaryDelegation(ctx.getCMSCtx(), docPath);
            String index = theRequest.getParameter("index");
            String type = theRequest.getParameter("type");
            String pictureContent = theRequest.getParameter("content");
            String fieldName = theRequest.getParameter("fieldName");
            String scope = theRequest.getParameter("scope");
            String forcedScope = theRequest.getParameter("forcedScope");
            String sLiveState = theRequest.getParameter("liveState");
            if (BooleanUtils.toBoolean((String)sLiveState)) {
                ctx.setDisplayLiveVersion("1");
            }
            ctx.setAuthType(NuxeoCommandContext.AUTH_TYPE_USER);
            if (delegation != null) {
                theRequest.setAttribute("osivia.delegation.userName", (Object)delegation.getUserName());
                if (delegation.isGrantedAccess()) {
                    ctx.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
                    ctx.setForcePublicationInfosScope("superuser_context");
                }
                theRequest.setAttribute("osivia.isAdmin", (Object)delegation.isAdmin());
                PageProperties.getProperties().setBinarySubject(delegation.getSubject());
            }
            if (scope != null) {
                ctx.setScope(scope);
            }
            if (forcedScope != null) {
                ctx.setForcePublicationInfosScope(forcedScope);
            }
            ctx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
            CMSBinaryContent content = null;
            BinaryDescription.Type binaryType = BinaryDescription.Type.valueOf((String)type);
            if (BinaryDescription.Type.ATTACHED_PICTURE.equals((Object)binaryType)) {
                content = ctx.fetchAttachedPicture(docPath, index);
            } else if (BinaryDescription.Type.PICTURE.equals((Object)binaryType)) {
                content = ctx.fetchPicture(docPath, pictureContent);
            } else if (BinaryDescription.Type.ATTACHED_FILE.equals((Object)binaryType)) {
                content = ResourceUtil.getCMSBinaryContent((NuxeoController)ctx, (String)docPath, (String)index);
            } else if (BinaryDescription.Type.BLOB.equals((Object)binaryType)) {
                content = ResourceUtil.getBlobHolderContent((NuxeoController)ctx, (String)docPath, (String)index);
            } else if (BinaryDescription.Type.FILE.equals((Object)binaryType)) {
                ctx.setStreamingSupport(true);
                content = ctx.fetchFileContent(docPath, fieldName);
                if (content.getStream() != null) {
                    theResponse.setContentType(content.getMimeType());
                    theResponse.setHeader("Content-Disposition", this.getHeaderContentDisposition(theRequest, content));
                    theResponse.setBufferSize(8192);
                    if (content.getFileSize() != null && content.getFileSize() < Integer.MAX_VALUE) {
                        theResponse.setContentLength(content.getFileSize().intValue());
                    }
                    BinaryServlet.streamBigFile((InputStream)content.getStream(), (OutputStream)output, (int)8192);
                    return;
                }
            }
            theResponse.setContentType(content.getMimeType());
            theResponse.setHeader("Content-Disposition", this.getHeaderContentDisposition(theRequest, content));
            theResponse.setHeader("Cache-Control", "max-age=" + BINARY_TIMEOUT);
            theResponse.setHeader("Last-Modified", this.formatResourceLastModified());
            ResourceUtil.copy((InputStream)new FileInputStream(content.getFile()), (OutputStream)theResponse.getOutputStream(), (int)4096);
        }
        catch (NuxeoException e) {
            if (e.getErrorCode() == NuxeoException.ERROR_NOTFOUND) {
                String message = "Resource BinaryServlet " + theRequest.getParameterMap() + " not found (error 404).";
                logger.error((Object)message);
                theResponse.setStatus(404);
                theRequest.setAttribute("osivia.no_redirection", (Object)"1");
            } else if (e.getErrorCode() == NuxeoException.ERROR_FORBIDDEN) {
                theResponse.setStatus(403);
                theRequest.setAttribute("osivia.no_redirection", (Object)"1");
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            output.close();
        }
    }

    private String getHeaderContentDisposition(HttpServletRequest request, CMSBinaryContent content) {
        String fileName = request.getParameter("fileName");
        if (fileName == null) {
            fileName = content.getName();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("attachment; filename=\"");
        builder.append(fileName);
        builder.append("\"");
        return builder.toString();
    }

    static {
        BINARY_TIMEOUT = 600L;
    }
}

