/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer;

import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.NavigationItemAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import java.util.Map;
import javax.portlet.PortletContext;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.core.cms.CMSItem;

public class CustomNavigationItemAdapter
extends NavigationItemAdapter {
    public CustomNavigationItemAdapter(PortletContext portletCtx, DefaultCMSCustomizer customizer, CMSService cmsService) {
        super(portletCtx, customizer, cmsService);
    }

    protected boolean isDisplayedAsAPage(Document doc) {
        if ("ServicePage".equals(doc.getType())) {
            return true;
        }
        return super.isDisplayedAsAPage(doc);
    }

    protected String getDefaultPageTemplate(Document doc) {
        if ("WebSite".equals(doc.getType())) {
            return "/default/templates/webSitepublish";
        }
        if ("BlogSite".equals(doc.getType())) {
            return "/default/templates/blogSite";
        }
        if ("Workspace".equals(doc.getType())) {
            return "/default/templates/workspace";
        }
        if ("ServicePage".equals(doc.getType())) {
            Object pageTemplate = doc.getProperties().get("ttc:pageTemplate");
            return pageTemplate.toString();
        }
        return "/default/templates/portalSitePublish";
    }

    public void adaptPublishSpaceNavigationItem(CMSItem publishSpaceNavigationItem, CMSItem publishSpaceItem) {
        super.adaptPublishSpaceNavigationItem(publishSpaceNavigationItem, publishSpaceItem);
        Document doc = (Document)publishSpaceNavigationItem.getNativeItem();
        Map properties = publishSpaceNavigationItem.getProperties();
        if ("Workspace".equals(doc.getType()) && StringUtils.endsWith((String)doc.getPath(), (String)"espace-theme-site-web")) {
            properties.put("theme", "osivia-sitesweb-theme");
        }
        if ("Folder".equals(doc.getType()) && StringUtils.endsWith((String)doc.getPath(), (String)"theme-defaut")) {
            properties.put("theme", "osivia-demo-charte");
        }
        if ("Workspace".equals(doc.getType()) && doc.getPath().contains("/UserWorkspaces/")) {
            properties.put("defaultTemplate", "1");
            properties.put("pageTemplate", "/default/templates/userWorkspace");
        }
    }
}

