/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.files;

import fr.toutatice.portail.cms.nuxeo.portlets.files.FileBrowserItem;
import fr.toutatice.portail.cms.nuxeo.portlets.files.FileBrowserSortCriteria;
import java.util.Comparator;
import java.util.Date;
import org.osivia.portal.core.cms.CMSItemType;

public class FileBrowserComparator
implements Comparator<FileBrowserItem> {
    private final FileBrowserSortCriteria criteria;

    public FileBrowserComparator(FileBrowserSortCriteria criteria) {
        this.criteria = criteria;
    }

    @Override
    public int compare(FileBrowserItem item1, FileBrowserItem item2) {
        int result = 0;
        String sort = this.criteria.getSort();
        if ("index".equals(sort)) {
            result = this.compare((Comparable)Integer.valueOf(item1.getIndex()), (Comparable)Integer.valueOf(item2.getIndex()));
        } else {
            boolean folderish2;
            CMSItemType type1 = item1.getType();
            boolean folderish1 = type1 != null && type1.isFolderish();
            CMSItemType type2 = item2.getType();
            boolean bl = folderish2 = type2 != null && type2.isFolderish();
            if (folderish1 && !folderish2) {
                return -1;
            }
            if (!folderish1 && folderish2) {
                return 1;
            }
            if ("name".equals(sort)) {
                result = this.compare((Comparable)((Object)item1.getTitle()), (Comparable)((Object)item2.getTitle()));
            } else if ("date".equals(sort)) {
                Date date2;
                Date date1 = (Date)item1.getProperties().get("dc:modified");
                if (date1 == null) {
                    date1 = (Date)item1.getProperties().get("dc:created");
                }
                if ((date2 = (Date)item2.getProperties().get("dc:modified")) == null) {
                    date2 = (Date)item2.getProperties().get("dc:created");
                }
                result = this.compare((Comparable)date1, (Comparable)date2);
            } else if ("contributor".equals(sort)) {
                String contributor1 = (String)item1.getProperties().get("dc:lastContributor");
                String contributor2 = (String)item2.getProperties().get("dc:lastContributor");
                result = this.compare((Comparable)((Object)contributor1), (Comparable)((Object)contributor2));
            } else if ("size".equals(sort)) {
                long size1 = 0L;
                String sizeProperty1 = (String)item1.getProperties().get("common:size");
                if (sizeProperty1 != null) {
                    size1 = Long.valueOf(sizeProperty1);
                }
                long size2 = 0L;
                String sizeProperty2 = (String)item2.getProperties().get("common:size");
                if (sizeProperty2 != null) {
                    size2 = Long.valueOf(sizeProperty2);
                }
                result = this.compare((Comparable)Long.valueOf(size1), (Comparable)Long.valueOf(size2));
            } else {
                result = 0;
            }
        }
        if (this.criteria.isAlternative()) {
            result = -result;
        }
        return result;
    }

    @Override
    private <T extends Comparable<T>> int compare(T object1, T object2) {
        int result;
        if (object1 == null) {
            result = -1;
        } else if (object2 == null) {
            result = 1;
        } else if (object1 instanceof String && object2 instanceof String) {
            String string1 = (String)((Object)object1);
            String string2 = (String)((Object)object2);
            result = string1.compareToIgnoreCase(string2);
        } else {
            result = object1.compareTo(object2);
        }
        return result;
    }
}

