/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.fragment;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.IFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.LinkFragmentBean;
import java.util.ArrayList;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class LinksFragmentModule
implements IFragmentModule {
    public static final String ID = "links_property";
    private static final String VIEW_JSP_NAME = "links";
    private static final String REF_URI = "refURI";
    private static final String TEMPLATE = "linksTemplate";
    private static IFragmentModule instance;

    private LinksFragmentModule() {
    }

    public static IFragmentModule getInstance() {
        if (instance == null) {
            instance = new LinksFragmentModule();
        }
        return instance;
    }

    public void doView(PortalControllerContext portalControllerContext) throws PortletException {
        RenderRequest request = (RenderRequest)portalControllerContext.getRequest();
        RenderResponse response = (RenderResponse)portalControllerContext.getResponse();
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, portalControllerContext.getPortletCtx());
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String nuxeoPath = window.getProperty("osivia.cms.uri");
        boolean emptyContent = true;
        if (StringUtils.isNotEmpty((String)nuxeoPath)) {
            String refURI;
            Document document = nuxeoController.fetchDocument(nuxeoPath = nuxeoController.getComputedPath(nuxeoPath));
            if (document.getTitle() != null) {
                response.setTitle(document.getTitle());
            }
            if (StringUtils.isNotEmpty((String)(refURI = window.getProperty("osivia.refURI")))) {
                String linksFragmentsSchema;
                String refURIValue;
                PropertyMap propertyMap;
                int index;
                PropertyList dataContents;
                Object content;
                String linksSchema = "lk:links";
                if (StringUtils.isNotEmpty((String)linksSchema)) {
                    ArrayList<LinkFragmentBean> links = new ArrayList<LinkFragmentBean>();
                    content = document.getProperties().get(linksSchema);
                    if (content instanceof PropertyList && (dataContents = (PropertyList)content) != null && dataContents.size() > 0) {
                        for (index = 0; index < dataContents.size(); ++index) {
                            propertyMap = dataContents.getMap(index);
                            refURIValue = (String)propertyMap.get(REF_URI);
                            String href = propertyMap.getString("href");
                            if (!refURI.equalsIgnoreCase(refURIValue) || !StringUtils.isNotBlank((String)href)) continue;
                            LinkFragmentBean link = new LinkFragmentBean(nuxeoController.getLinkFromNuxeoURL(href));
                            link.setTitle(propertyMap.getString("title"));
                            link.setGlyphicon(propertyMap.getString("icon"));
                            links.add(link);
                        }
                    }
                    if (!links.isEmpty()) {
                        request.setAttribute(VIEW_JSP_NAME, links);
                        emptyContent = false;
                    }
                }
                if (StringUtils.isNotEmpty((String)(linksFragmentsSchema = "lkfgt:linksFragment")) && (content = document.getProperties().get(linksFragmentsSchema)) instanceof PropertyList && (dataContents = (PropertyList)content) != null && dataContents.size() > 0) {
                    for (index = 0; index < dataContents.size(); ++index) {
                        propertyMap = dataContents.getMap(index);
                        refURIValue = (String)propertyMap.get(REF_URI);
                        if (!refURI.equalsIgnoreCase(refURIValue)) continue;
                        request.setAttribute("template", (Object)propertyMap.getString(TEMPLATE));
                        break;
                    }
                }
            }
        }
        if (emptyContent) {
            request.setAttribute("osivia.emptyResponse", (Object)"1");
        }
    }

    public void doAdmin(PortalControllerContext portalControllerContext) throws PortletException {
    }

    public void processAdminAction(PortalControllerContext portalControllerContext) throws PortletException {
    }

    public boolean isDisplayedInAdmin() {
        return false;
    }

    public String getViewJSPName() {
        return VIEW_JSP_NAME;
    }

    public String getAdminJSPName() {
        return null;
    }
}

