/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.list;

import bsh.EvalError;
import bsh.Interpreter;
import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PageSelectors;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.api.ResourceUtil;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.ListTemplate;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import fr.toutatice.portail.cms.nuxeo.portlets.list.DocumentComparator;
import fr.toutatice.portail.cms.nuxeo.portlets.list.ListCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.list.ListConfiguration;
import fr.toutatice.portail.cms.nuxeo.portlets.list.NXQLFormater;
import fr.toutatice.portail.cms.nuxeo.portlets.list.RssGenerator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PaginableDocuments;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.context.ControllerContextAdapter;

public class ViewListPortlet
extends CMSPortlet {
    public static final String NUXEO_REQUEST_WINDOW_PROPERTY = "osivia.nuxeoRequest";
    public static final String BEAN_SHELL_WINDOW_PROPERTY = "osivia.beanShell";
    public static final String USE_ES_WINDOW_PROPERTY = "osivia.useES";
    public static final String VERSION_WINDOW_PROPERTY = "osivia.cms.displayLiveVersion";
    public static final String CONTENT_FILTER_WINDOW_PROPERTY = "osivia.cms.requestFilteringPolicy";
    public static final String SCOPE_WINDOW_PROPERTY = "osivia.cms.scope";
    public static final String METADATA_WINDOW_PROPERTY = "osivia.cms.hideMetaDatas";
    public static final String NUXEO_REQUEST_DISPLAY_WINDOW_PROPERTY = "osivia.displayNuxeoRequest";
    public static final String RESULTS_LIMIT_WINDOW_PROPERTY = "osivia.cms.maxItems";
    public static final String NORMAL_PAGINATION_WINDOW_PROPERTY = "osivia.cms.pageSize";
    public static final String MAXIMIZED_PAGINATION_WINDOW_PROPERTY = "osivia.cms.pageSizeMax";
    public static final String TEMPLATE_WINDOW_PROPERTY = "osivia.cms.style";
    public static final String PERMALINK_REFERENCE_WINDOW_PROPERTY = "osivia.permaLinkRef";
    public static final String RSS_REFERENCE_WINDOW_PROPERTY = "osivia.rssLinkRef";
    public static final String RSS_TITLE_WINDOW_PROPERTY = "osivia.rssTitle";
    public static final String CREATION_PARENT_PATH_WINDOW_PROPERTY = "osivia.createParentPath";
    public static final String CREATION_CONTENT_TYPE_WINDOW_PROPERTY = "osivia.createDocType";
    private static final int DEFAULT_REQUEST_PAGE_SIZE = 100;
    private static final int DEFAULT_RSS_RESULTS_LIMIT = 10;
    private static final String PATH_ADMIN = "/WEB-INF/jsp/list/admin.jsp";
    private static final String PATH_VIEW = "/WEB-INF/jsp/list/view.jsp";
    private IBundleFactory bundleFactory;
    private DocumentDAO documentDAO;
    private INuxeoCustomizer customizer;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
        this.documentDAO = DocumentDAO.getInstance();
        INuxeoService nuxeoService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
        this.customizer = nuxeoService.getCMSCustomizer();
    }

    public ListTemplate getCurrentTemplate(Locale locale, ListConfiguration configuration) {
        String currentTemplateName = configuration.getTemplate();
        if (currentTemplateName == null) {
            currentTemplateName = "normal";
        }
        ListTemplate currentTemplate = null;
        ListTemplate defaultTemplate = null;
        List templates = this.customizer.getListTemplates(locale);
        for (ListTemplate template : templates) {
            if (currentTemplateName.equals(template.getKey())) {
                currentTemplate = template;
                break;
            }
            if (!"normal".equals(template.getKey())) continue;
            defaultTemplate = template;
        }
        if (currentTemplate == null) {
            currentTemplate = defaultTemplate;
        }
        return currentTemplate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        try {
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            ListConfiguration configuration = this.getConfiguration(window);
            if ("rss".equals(request.getParameter("type"))) {
                String nuxeoRequest = configuration.getNuxeoRequest();
                if (configuration.isBeanShell()) {
                    Interpreter interpreter = new Interpreter();
                    interpreter.set("params", (Object)PageSelectors.decodeProperties((String)request.getParameter("selectors")));
                    interpreter.set("request", (Object)request);
                    interpreter.set("NXQLFormater", (Object)new NXQLFormater());
                    interpreter.set("basePath", (Object)nuxeoController.getBasePath());
                    interpreter.set("spacePath", (Object)nuxeoController.getSpacePath());
                    interpreter.set("navigationPath", (Object)nuxeoController.getNavigationPath());
                    interpreter.set("contentPath", (Object)nuxeoController.getContentPath());
                    nuxeoRequest = (String)interpreter.eval(nuxeoRequest);
                }
                int resultsLimit = 10;
                if (configuration.getMaximizedPagination() != null) {
                    resultsLimit = configuration.getMaximizedPagination();
                }
                if (nuxeoRequest == null) throw new IllegalArgumentException("No request defined for RSS");
                ListTemplate template = this.getCurrentTemplate(request.getLocale(), configuration);
                String schemas = template.getSchemas();
                ListCommand command = new ListCommand(nuxeoRequest, nuxeoController.isDisplayingLiveVersion(), 0, resultsLimit, schemas, configuration.getContentFilter(), configuration.isUseES());
                PaginableDocuments documents = (PaginableDocuments)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                org.w3c.dom.Document document = RssGenerator.createDocument((NuxeoController)nuxeoController, (PortalControllerContext)portalControllerContext, (String)configuration.getRssTitle(), (PaginableDocuments)documents, (String)configuration.getRssReference());
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(document);
                StringWriter stringWriter = new StringWriter();
                StreamResult streamResult = new StreamResult(stringWriter);
                transformer.transform(source, streamResult);
                String xmlString = stringWriter.toString();
                ByteArrayInputStream in = new ByteArrayInputStream(xmlString.getBytes());
                ResourceUtil.copy((InputStream)in, (OutputStream)response.getPortletOutputStream(), (int)4096);
                response.setContentType("application/rss+xml");
                response.setProperty("Cache-Control", "max-age=" + response.getCacheControl().getExpirationTime());
                response.setProperty("Last-Modified", this.formatResourceLastModified());
                return;
            } else {
                super.serveResource(request, response);
            }
            return;
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        String action = request.getParameter("javax.portlet.action");
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        if ("admin".equals(request.getPortletMode().toString())) {
            if ("save".equals(action)) {
                window.setProperty(NUXEO_REQUEST_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("nuxeoRequest")));
                window.setProperty(BEAN_SHELL_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("beanShell")));
                window.setProperty(USE_ES_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("useES")));
                window.setProperty(VERSION_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("displayLiveVersion")));
                window.setProperty(CONTENT_FILTER_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("requestFilteringPolicy")));
                window.setProperty(SCOPE_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("scope")));
                boolean displayMetadata = BooleanUtils.toBoolean((String)request.getParameter("metadataDisplay"));
                window.setProperty(METADATA_WINDOW_PROPERTY, BooleanUtils.toString((boolean)displayMetadata, null, (String)"1"));
                window.setProperty(NUXEO_REQUEST_DISPLAY_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("nuxeoRequestDisplay")));
                window.setProperty(RESULTS_LIMIT_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("resultsLimit")));
                window.setProperty(NORMAL_PAGINATION_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("normalPagination")));
                window.setProperty(MAXIMIZED_PAGINATION_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("maximizedPagination")));
                window.setProperty(TEMPLATE_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("template")));
                window.setProperty(PERMALINK_REFERENCE_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("permalinkReference")));
                window.setProperty(RSS_REFERENCE_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("rssReference")));
                window.setProperty(RSS_TITLE_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("rssTitle")));
                window.setProperty(CREATION_PARENT_PATH_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("creationParentPath")));
                window.setProperty(CREATION_CONTENT_TYPE_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("creationContentType")));
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        }
        ListConfiguration configuration = this.getConfiguration(window);
        ListTemplate template = this.getCurrentTemplate(request.getLocale(), configuration);
        if (template.getModule() != null) {
            try {
                template.getModule().processAction(nuxeoController.getPortalCtx(), window, request, response);
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        try {
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            ListConfiguration configuration = this.getConfiguration(window);
            request.setAttribute("configuration", (Object)configuration);
            request.setAttribute("versions", (Object)nuxeoController.formatDisplayLiveVersionList(configuration.getVersion()));
            request.setAttribute("contentFilters", (Object)nuxeoController.formatRequestFilteringPolicyList(configuration.getContentFilter()));
            request.setAttribute("scopes", (Object)nuxeoController.formatScopeList(configuration.getScope()));
            request.setAttribute("templates", (Object)this.customizer.getListTemplates(request.getLocale()));
            response.setContentType("text/html");
            PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(PATH_ADMIN);
            dispatcher.include(request, response);
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, PortletSecurityException, IOException {
        try {
            String nuxeoRequest;
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            request.setAttribute("nuxeoController", (Object)nuxeoController);
            PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            ListConfiguration configuration = this.getConfiguration(window);
            Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
            boolean feed = BooleanUtils.toBoolean((String)window.getProperty("osivia.cms.feed"));
            HashMap<String, Integer> feedDocumentsOrder = null;
            if (feed) {
                int size = NumberUtils.toInt((String)window.getProperty("osivia.cms.news.size"));
                feedDocumentsOrder = new HashMap<String, Integer>(size);
                StringBuilder builder = new StringBuilder();
                builder.append("return \"");
                for (int i = 0; i < size; ++i) {
                    if (i > 0) {
                        builder.append(" OR ");
                    }
                    String path = window.getProperty("osivia.cms.news." + i + ".docURI");
                    feedDocumentsOrder.put(path, NumberUtils.toInt((String)window.getProperty("osivia.cms.news." + i + ".order")));
                    builder.append("ecm:path = '").append(path).append("'");
                }
                builder.append("\";");
                nuxeoRequest = builder.toString();
            } else {
                nuxeoRequest = configuration.getNuxeoRequest();
            }
            if (configuration.isBeanShell()) {
                String orginalRequest = nuxeoRequest;
                if ((nuxeoRequest = this.beanShellInterpretation(nuxeoController, nuxeoRequest)) != null && nuxeoRequest.matches("(.|\n|\r)*('null)(.|\n|\r)*") && nuxeoController.getBasePath() == null && orginalRequest.matches("(.|\n|\r)*(basePath|domainPath|spacePath|navigationPath)(.|\n|\r)*")) {
                    nuxeoRequest = null;
                }
            }
            if ("EMPTY_REQUEST".equals(nuxeoRequest)) {
                request.setAttribute("osivia.emptyResponse", (Object)"1");
                request.setAttribute("error", (Object)bundle.getString("LIST_MESSAGE_EMPTY_REQUEST"));
            } else if (nuxeoRequest != null) {
                String dynamicPath;
                if (configuration.isNuxeoRequestDisplay()) {
                    request.setAttribute("nuxeoRequest", (Object)nuxeoRequest);
                }
                String cmsPath = request.getParameter("osivia.cms.path");
                String selectors = request.getParameter("selectors");
                String lastSelectors = request.getParameter("lastSelectors");
                request.setAttribute("selectors", (Object)selectors);
                int resultsLimit = configuration.getResultsLimit() == null ? -1 : configuration.getResultsLimit();
                int pageSize = -1;
                int currentPage = 0;
                Integer pageSizeProperty = WindowState.MAXIMIZED.equals((Object)request.getWindowState()) ? configuration.getMaximizedPagination() : configuration.getNormalPagination();
                if (pageSizeProperty != null) {
                    boolean selectorsChanged;
                    pageSize = pageSizeProperty;
                    String currentStateParameter = request.getParameter("currentState");
                    String currentPageParameter = request.getParameter("currentPage");
                    boolean modeChanged = !request.getWindowState().toString().equals(currentStateParameter);
                    boolean bl = selectorsChanged = selectors != null && !selectors.equals(lastSelectors) || selectors == null && lastSelectors != null;
                    if (currentPageParameter != null && !modeChanged && !selectorsChanged) {
                        currentPage = NumberUtils.toInt((String)currentPageParameter);
                    }
                }
                request.setAttribute("currentPage", (Object)currentPage);
                request.setAttribute("templates", (Object)this.customizer.getListTemplates(request.getLocale()));
                String templateName = configuration.getTemplate();
                if (templateName == null) {
                    templateName = "normal";
                }
                ListTemplate template = this.getCurrentTemplate(request.getLocale(), configuration);
                request.setAttribute("style", (Object)StringUtils.lowerCase((String)template.getKey()));
                String schemas = template.getSchemas();
                int requestPageSize = 100;
                if (pageSize > 0) {
                    requestPageSize = pageSize;
                }
                if (resultsLimit > 0 && currentPage == 0) {
                    requestPageSize = Math.min(requestPageSize, resultsLimit);
                }
                ListCommand command = new ListCommand(nuxeoRequest, nuxeoController.isDisplayingLiveVersion(), currentPage, requestPageSize, schemas, configuration.getContentFilter(), configuration.isUseES());
                PaginableDocuments documents = (PaginableDocuments)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                List documentsList = documents.list();
                if (feed) {
                    DocumentComparator comparator = new DocumentComparator(feedDocumentsOrder);
                    Collections.sort(documentsList, comparator);
                }
                ArrayList<DocumentDTO> documentsDTO = new ArrayList<DocumentDTO>(documentsList.size());
                for (Document document : documentsList) {
                    DocumentDTO documentDTO = this.documentDAO.toDTO(document);
                    documentsDTO.add(documentDTO);
                }
                request.setAttribute("documents", documentsDTO);
                int pagesCount = 0;
                if (pageSize > 0) {
                    int limit;
                    if (resultsLimit > 0) {
                        limit = Math.min(documents.getTotalSize(), resultsLimit);
                        if (documents.size() < (currentPage + 1) * requestPageSize) {
                            int lastPageLimit = Math.max(0, resultsLimit - currentPage * requestPageSize);
                            while (documents.size() > lastPageLimit) {
                                documentsList.remove(documents.size() - 1);
                            }
                        }
                    } else {
                        limit = documents.getTotalSize();
                    }
                    pagesCount = (limit - 1) / pageSize + 1;
                }
                request.setAttribute("nbPages", (Object)pagesCount);
                request.setAttribute("totalSize", (Object)documents.getTotalSize());
                if (StringUtils.isNotBlank((String)configuration.getPermalinkReference())) {
                    String type;
                    String reference = configuration.getPermalinkReference();
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    if (selectors != null) {
                        Map decodedSelectors = PageSelectors.decodeProperties((String)selectors);
                        decodedSelectors.remove("selectorChanged");
                        parameters.put("selectors", PageSelectors.encodeProperties((Map)decodedSelectors));
                    }
                    if (cmsPath == null) {
                        type = "page";
                    } else {
                        type = "cms";
                        reference = null;
                    }
                    String url = nuxeoController.getPortalUrlFactory().getPermaLink(portalControllerContext, reference, parameters, cmsPath, type);
                    request.setAttribute("permaLinkURL", (Object)url);
                }
                if (StringUtils.isNotBlank((String)configuration.getRssReference())) {
                    boolean anonymousAccess = true;
                    if (cmsPath != null) {
                        CMSServiceCtx cmsContext = new CMSServiceCtx();
                        cmsContext.setControllerContext(ControllerContextAdapter.getControllerContext((PortalControllerContext)portalControllerContext));
                        cmsContext.setScope(nuxeoController.getScope());
                        anonymousAccess = NuxeoController.getCMSService().checkContentAnonymousAccess(cmsContext, cmsPath);
                    }
                    if (anonymousAccess) {
                        HashMap<String, String> publicParams = new HashMap<String, String>();
                        if (selectors != null) {
                            Map selectorsMap = PageSelectors.decodeProperties((String)selectors);
                            selectorsMap.remove("selectorChanged");
                            publicParams.put("selectors", PageSelectors.encodeProperties((Map)selectorsMap));
                        }
                        String url = nuxeoController.getPortalUrlFactory().getPermaLink(portalControllerContext, configuration.getRssReference(), publicParams, cmsPath, "rss");
                        request.setAttribute("rssLinkURL", (Object)url);
                    }
                }
                if ((dynamicPath = window.getProperty("osivia.cms.uri")) != null) {
                    dynamicPath = nuxeoController.getLivePath(dynamicPath);
                    Document folder = nuxeoController.fetchDocument(dynamicPath);
                    nuxeoController.setCurrentDoc(folder);
                    response.setTitle(folder.getTitle());
                }
                nuxeoController.insertContentMenuBarItems();
                if (currentPage == 0 && documents.size() == 0) {
                    request.setAttribute("osivia.emptyResponse", (Object)"1");
                }
                if (template.getModule() != null) {
                    template.getModule().doView(portalControllerContext, window, request, response);
                }
            } else {
                String bshTitle = (String)request.getAttribute("bsh.title");
                String bshHTML = (String)request.getAttribute("bsh.html");
                if (StringUtils.isNotEmpty((String)bshTitle) || StringUtils.isNotEmpty((String)bshHTML)) {
                    if (StringUtils.isNotEmpty((String)bshTitle)) {
                        response.setTitle(bshTitle);
                    }
                    if (StringUtils.isNotEmpty((String)bshHTML)) {
                        response.setContentType("text/html");
                        response.getWriter().print(bshHTML);
                        response.getWriter().close();
                    }
                    return;
                }
                request.setAttribute("error", (Object)"Requ\u00eate non d\u00e9finie");
            }
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (EvalError e) {
            request.setAttribute("error", (Object)"LIST_MESSAGE_INVALID_REQUEST");
            request.setAttribute("errorMessage", (Object)e.getMessage());
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        response.setContentType("text/html");
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(PATH_VIEW);
        dispatcher.include(request, response);
    }

    private String beanShellInterpretation(NuxeoController nuxeoController, String nuxeoRequest) throws EvalError, CMSException {
        PortletRequest request = nuxeoController.getRequest();
        Interpreter interpreter = new Interpreter();
        interpreter.set("params", (Object)PageSelectors.decodeProperties((String)request.getParameter("selectors")));
        interpreter.set("basePath", (Object)nuxeoController.getBasePath());
        interpreter.set("domainPath", (Object)nuxeoController.getDomainPath());
        interpreter.set("spacePath", (Object)nuxeoController.getSpacePath());
        interpreter.set("navigationPath", (Object)nuxeoController.getNavigationPath());
        interpreter.set("navigationPubInfos", null);
        interpreter.set("spaceId", null);
        if (nuxeoController.getNavigationPath() != null) {
            CMSPublicationInfos navigationPubInfos = NuxeoController.getCMSService().getPublicationInfos(nuxeoController.getCMSCtx(), nuxeoController.getNavigationPath());
            interpreter.set("navigationPubInfos", (Object)navigationPubInfos);
            interpreter.set("spaceId", (Object)navigationPubInfos.getSpaceID());
        }
        interpreter.set("contentPath", (Object)nuxeoController.getContentPath());
        interpreter.set("request", (Object)request);
        interpreter.set("NXQLFormater", (Object)new NXQLFormater());
        interpreter.set("navItem", (Object)nuxeoController.getNavigationItem());
        return (String)interpreter.eval(nuxeoRequest);
    }

    private ListConfiguration getConfiguration(PortalWindow window) {
        ListConfiguration configuration = new ListConfiguration();
        configuration.setNuxeoRequest(window.getProperty(NUXEO_REQUEST_WINDOW_PROPERTY));
        configuration.setBeanShell(BooleanUtils.toBoolean((String)window.getProperty(BEAN_SHELL_WINDOW_PROPERTY)));
        configuration.setUseES(BooleanUtils.toBoolean((String)window.getProperty(USE_ES_WINDOW_PROPERTY)));
        configuration.setVersion(window.getProperty(VERSION_WINDOW_PROPERTY));
        configuration.setContentFilter(window.getProperty(CONTENT_FILTER_WINDOW_PROPERTY));
        configuration.setScope(window.getProperty(SCOPE_WINDOW_PROPERTY));
        configuration.setMetadataDisplay(BooleanUtils.toBoolean((String)window.getProperty(METADATA_WINDOW_PROPERTY), null, (String)"1"));
        configuration.setNuxeoRequestDisplay(BooleanUtils.toBoolean((String)window.getProperty(NUXEO_REQUEST_DISPLAY_WINDOW_PROPERTY)));
        configuration.setResultsLimit(NumberUtils.createInteger((String)StringUtils.trimToNull((String)window.getProperty(RESULTS_LIMIT_WINDOW_PROPERTY))));
        configuration.setNormalPagination(NumberUtils.createInteger((String)StringUtils.trimToNull((String)window.getProperty(NORMAL_PAGINATION_WINDOW_PROPERTY))));
        configuration.setMaximizedPagination(NumberUtils.createInteger((String)StringUtils.trimToNull((String)window.getProperty(MAXIMIZED_PAGINATION_WINDOW_PROPERTY))));
        configuration.setTemplate(window.getProperty(TEMPLATE_WINDOW_PROPERTY));
        configuration.setPermalinkReference(window.getProperty(PERMALINK_REFERENCE_WINDOW_PROPERTY));
        configuration.setRssReference(window.getProperty(RSS_REFERENCE_WINDOW_PROPERTY));
        configuration.setRssTitle(window.getProperty(RSS_TITLE_WINDOW_PROPERTY));
        configuration.setCreationParentPath(window.getProperty(CREATION_PARENT_PATH_WINDOW_PROPERTY));
        configuration.setCreationContentType(window.getProperty(CREATION_CONTENT_TYPE_WINDOW_PROPERTY));
        return configuration;
    }
}

