/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.move;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import fr.toutatice.portail.cms.nuxeo.portlets.files.MoveDocumentCommand;
import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSObjectPath;

public class MoveDocumentPortlet
extends CMSPortlet {
    public static final String DOCUMENT_PATH_WINDOW_PROPERTY = "osivia.move.documentPath";
    public static final String CMS_BASE_PATH_WINDOW_PROPERTY = "osivia.move.cmsBasePath";
    public static final String ACCEPTED_TYPE_WINDOW_PROPERTY = "osivia.move.acceptedType";
    private static final String SPACE_PATH_REQUEST_PARAMETER = "osivia.move.spacePath";
    private static final String MODE_REQUEST_PARAMETER = "osivia.move.mode";
    private static final String VIEW_PATH = "/WEB-INF/jsp/move/view.jsp";
    private static final String CHANGE_SPACE_PATH = "/WEB-INF/jsp/move/change-space.jsp";
    private DocumentDAO documentDAO;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.documentDAO = DocumentDAO.getInstance();
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String documentPath = window.getProperty(DOCUMENT_PATH_WINDOW_PROPERTY);
        request.setAttribute("documentPath", (Object)documentPath);
        String cmsBasePath = request.getParameter(SPACE_PATH_REQUEST_PARAMETER);
        if (cmsBasePath == null) {
            cmsBasePath = window.getProperty(CMS_BASE_PATH_WINDOW_PROPERTY);
        }
        if (cmsBasePath != null) {
            cmsBasePath = nuxeoController.getComputedPath(cmsBasePath);
            request.setAttribute("cmsBasePath", (Object)cmsBasePath);
            Document spaceRootDocument = nuxeoController.fetchDocument(cmsBasePath);
            DocumentDTO spaceRootDocumentDTO = this.documentDAO.toDTO(spaceRootDocument);
            request.setAttribute("spaceDocument", (Object)spaceRootDocumentDTO);
        }
        String acceptedType = window.getProperty(ACCEPTED_TYPE_WINDOW_PROPERTY);
        request.setAttribute("acceptedType", (Object)acceptedType);
        String dispatcherPath = "space".equals(request.getParameter(MODE_REQUEST_PARAMETER)) ? CHANGE_SPACE_PATH : VIEW_PATH;
        response.setContentType("text/html");
        this.getPortletContext().getRequestDispatcher(dispatcherPath).include(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        Bundle bundle = this.getBundleFactory().getBundle(request.getLocale());
        String action = request.getParameter("javax.portlet.action");
        if ("move".equals(action)) {
            String path = window.getProperty(DOCUMENT_PATH_WINDOW_PROPERTY);
            String targetPath = request.getParameter("targetPath");
            if (path != null) {
                if (StringUtils.isNotBlank((String)targetPath)) {
                    Document document = nuxeoController.fetchDocument(path);
                    Document targetDocument = nuxeoController.fetchDocument(targetPath);
                    CMSObjectPath parentPath = CMSObjectPath.parse((String)document.getPath()).getParent();
                    MoveDocumentCommand command = new MoveDocumentCommand(document.getId(), targetDocument.getId());
                    nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                    String redirectionURL = this.getPortalUrlFactory().getCMSUrl(portalControllerContext, null, parentPath.toString(), null, null, null, null, null, null, null);
                    redirectionURL = this.getPortalUrlFactory().adaptPortalUrlToPopup(portalControllerContext, redirectionURL, 1);
                    request.setAttribute("osivia.redirection.url", (Object)redirectionURL);
                    this.getNotificationsService().addSimpleNotification(portalControllerContext, bundle.getString("DOCUMENT_MOVE_SUCCESS_MESSAGE"), NotificationsType.SUCCESS);
                } else {
                    String redirectionURL = this.getPortalUrlFactory().getCMSUrl(portalControllerContext, null, path, null, null, null, null, null, null, null);
                    redirectionURL = this.getPortalUrlFactory().adaptPortalUrlToPopup(portalControllerContext, redirectionURL, 1);
                    request.setAttribute("osivia.redirection.url", (Object)redirectionURL);
                    this.getNotificationsService().addSimpleNotification(portalControllerContext, bundle.getString("DOCUMENT_MOVE_WARNING_MESSAGE"), NotificationsType.WARNING);
                }
            }
        } else if ("changeSpace".equals(action)) {
            String spacePath = request.getParameter("spacePath");
            response.setRenderParameter(SPACE_PATH_REQUEST_PARAMETER, spacePath);
        }
    }
}

