/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.tags;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.Window;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.portalobjects.PortalObjectUtils;
import org.osivia.portal.core.web.IWebIdService;

public class DocumentLinkTag
extends SimpleTagSupport {
    private DocumentDTO document;
    private String property;
    private String displayContext;
    private Boolean picture;
    private Boolean permalink;
    private String var;
    private final IWebIdService webIdService = (IWebIdService)Locator.findMBean(IWebIdService.class, (String)"osivia:service=webIdService");

    public void doTag() throws JspException, IOException {
        PageContext pageContext = (PageContext)this.getJspContext();
        ServletRequest request = pageContext.getRequest();
        NuxeoController nuxeoController = (NuxeoController)request.getAttribute("nuxeoController");
        if (nuxeoController != null && this.document != null) {
            Link link;
            if (StringUtils.isEmpty((String)this.property)) {
                Document nuxeoDocument = this.document.getDocument();
                if (BooleanUtils.isTrue((Boolean)this.picture)) {
                    String path = nuxeoDocument.getPath();
                    String url = nuxeoController.createPictureLink(path, StringUtils.defaultIfEmpty((String)this.displayContext, (String)"Original"));
                    link = new Link(url, false);
                } else if (BooleanUtils.isTrue((Boolean)this.permalink)) {
                    PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
                    Page page = null;
                    Window window = (Window)nuxeoController.getRequest().getAttribute("osivia.window");
                    if (window != null) {
                        page = window.getPage();
                    }
                    try {
                        CMSServiceCtx cmsContext;
                        CMSService cmsService;
                        CMSItem cmsItem;
                        String path = this.document.getPath();
                        if (PortalObjectUtils.isSpaceSite((PortalObject)page) && StringUtils.isNotEmpty((String)(cmsItem = (cmsService = (CMSService)NuxeoController.getCMSService()).createItem(cmsContext = nuxeoController.getCMSCtx(), this.document.getPath(), null, nuxeoDocument)).getDomainId()) && StringUtils.isNotEmpty((String)cmsItem.getWebId())) {
                            path = this.webIdService.itemToPageUrl(cmsContext, cmsItem);
                        }
                        String url = nuxeoController.getPortalUrlFactory().getPermaLink(portalControllerContext, null, null, path, "cms");
                        link = new Link(url, false);
                    }
                    catch (Exception e) {
                        link = new Link("#", false);
                    }
                } else {
                    link = nuxeoController.getLink(nuxeoDocument, StringUtils.trimToNull((String)this.displayContext));
                }
            } else {
                String value = String.valueOf(this.document.getProperties().get(this.property));
                link = nuxeoController.getLinkFromNuxeoURL(value);
            }
            if (StringUtils.isEmpty((String)this.var)) {
                JspWriter out = pageContext.getOut();
                out.write(link.getUrl());
            } else {
                request.setAttribute(this.var, (Object)link);
            }
        }
    }

    public DocumentDTO getDocument() {
        return this.document;
    }

    public void setDocument(DocumentDTO document) {
        this.document = document;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getDisplayContext() {
        return this.displayContext;
    }

    public void setDisplayContext(String displayContext) {
        this.displayContext = displayContext;
    }

    public Boolean getPicture() {
        return this.picture;
    }

    public void setPicture(Boolean picture) {
        this.picture = picture;
    }

    public Boolean getPermalink() {
        return this.permalink;
    }

    public void setPermalink(Boolean permalink) {
        this.permalink = permalink;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }
}

