/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.tags;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.commons.lang.BooleanUtils;
import org.dom4j.Element;
import org.dom4j.io.HTMLWriter;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.core.cms.CMSItemType;

public class DocumentTitleTag
extends SimpleTagSupport {
    private DocumentDTO document;
    private Boolean link;
    private String displayContext;
    private Boolean icon;

    public void doTag() throws JspException, IOException {
        Element container;
        CMSItemType type;
        PageContext pageContext = (PageContext)this.getJspContext();
        ServletRequest request = pageContext.getRequest();
        NuxeoController nuxeoController = (NuxeoController)request.getAttribute("nuxeoController");
        String glyphicon = null;
        if (BooleanUtils.isTrue((Boolean)this.icon) && (type = this.document.getType()) != null) {
            glyphicon = type.getGlyph();
        }
        if (BooleanUtils.isFalse((Boolean)this.link) || nuxeoController == null) {
            container = DOM4JUtils.generateElement((String)"span", null, (String)this.document.getTitle(), (String)glyphicon, null);
        } else {
            container = DOM4JUtils.generateElement((String)"span", null, null);
            Link documentLink = nuxeoController.getLink(this.document.getDocument(), this.displayContext);
            String target = null;
            if (documentLink.isExternal()) {
                target = "_blank";
            }
            Element linkElement = DOM4JUtils.generateLinkElement((String)documentLink.getUrl(), (String)target, null, (String)"no-ajax-link", (String)this.document.getTitle(), (String)glyphicon);
            container.add(linkElement);
            if (documentLink.isExternal()) {
                Element externalElement = DOM4JUtils.generateElement((String)"small", null, null, (String)"glyphicons glyphicons-new-window-alt", null);
                container.add(externalElement);
            }
            if (documentLink.isDownloadable()) {
                Element downloadableElement = DOM4JUtils.generateElement((String)"small", null, null, (String)"halflings halflings-download-alt", null);
                container.add(downloadableElement);
            }
        }
        HTMLWriter htmlWriter = new HTMLWriter((Writer)pageContext.getOut());
        htmlWriter.write(container);
    }

    public void setDocument(DocumentDTO document) {
        this.document = document;
    }

    public void setLink(Boolean link) {
        this.link = link;
    }

    public void setDisplayContext(String displayContext) {
        this.displayContext = displayContext;
    }

    public void setIcon(Boolean icon) {
        this.icon = icon;
    }
}

