/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.tags;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyEntry;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyHelper;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetVocabularyLabelTag
extends SimpleTagSupport {
    private final Log log = LogFactory.getLog(this.getClass());
    private String name;
    private String key;

    public void doTag() throws JspException, IOException {
        try {
            PageContext pageContext = (PageContext)this.getJspContext();
            ServletRequest request = pageContext.getRequest();
            NuxeoController nuxeoController = (NuxeoController)request.getAttribute("nuxeoController");
            if (nuxeoController != null) {
                String[] keys;
                StringBuilder sb = new StringBuilder("");
                if (StringUtils.contains((String)this.key, (String)"[")) {
                    String[] substringsBetween = StringUtils.substringsBetween((String)this.key, (String)"[", (String)"]");
                    keys = StringUtils.split((String)substringsBetween[0], (String)",");
                } else {
                    keys = new String[]{this.key};
                }
                for (int i = 0; i < keys.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    keys[i] = StringUtils.trim((String)keys[i]);
                    if (StringUtils.contains((String)keys[i], (String)"/")) {
                        String[] subKeys = StringUtils.split((String)keys[i], (String)"/");
                        VocabularyEntry vocabularyEntryRoot = VocabularyHelper.getVocabularyEntry((NuxeoController)nuxeoController, (String)this.name, (Boolean)true);
                        VocabularyEntry parent = vocabularyEntryRoot.getChild(subKeys[0]);
                        sb.append(StringUtils.clean((String)parent.getLabel()));
                        VocabularyEntry child = parent.getChild(subKeys[1]);
                        if (child == null) continue;
                        sb.append(" / ");
                        sb.append(StringUtils.clean((String)child.getLabel()));
                        continue;
                    }
                    sb.append(StringUtils.trimToEmpty((String)VocabularyHelper.getVocabularyLabel((NuxeoController)nuxeoController, (String)this.name, (String)keys[i])));
                }
                String label = sb.toString();
                JspWriter out = pageContext.getOut();
                out.write(label);
            }
        }
        catch (NuxeoException e) {
            this.log.error((Object)(e.getMessage() + " ; name=" + this.name + ", key=" + this.key));
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

