/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.tags;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;

public class TransformHTMLTag
extends SimpleTagSupport {
    private DocumentDTO document;
    private String property;

    public void doTag() throws JspException, IOException {
        PageContext pageContext = (PageContext)this.getJspContext();
        ServletRequest request = pageContext.getRequest();
        NuxeoController nuxeoController = (NuxeoController)request.getAttribute("nuxeoController");
        if (nuxeoController != null && this.document != null) {
            Document nuxeoDocument = this.document.getDocument();
            String htmlContent = StringUtils.trimToEmpty((String)nuxeoDocument.getString(this.property));
            htmlContent = nuxeoController.transformHTMLContent(htmlContent);
            JspWriter out = pageContext.getOut();
            out.write(htmlContent);
        }
    }

    public DocumentDTO getDocument() {
        return this.document;
    }

    public void setDocument(DocumentDTO document) {
        this.document = document;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }
}

