/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.client;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class ClientInfos {
    private static final String HEADER_ACCEPT = "accept";
    public static final String LE_MIME_TYPE = "application/x-nuxeo-liveedit";
    private boolean clientHasLiveEditInstalled = false;
    private List<String> nxLiveEditMimeTypes = new ArrayList(1);

    public ClientInfos(HttpServletRequest request) {
        this.setLiveEditMimeTypes(request);
    }

    public List<String> getNxLiveEditMimeTypes() {
        return this.nxLiveEditMimeTypes;
    }

    public boolean isClientHasLiveEditInstalled() {
        return this.clientHasLiveEditInstalled;
    }

    public void setLiveEditMimeTypes(HttpServletRequest request) {
        String[] accepted;
        String accept = request.getHeader(HEADER_ACCEPT);
        if (accept == null) {
            return;
        }
        for (String acceptHeader : accepted = accept.split(",")) {
            String[] subTypes;
            if (acceptHeader == null || !(acceptHeader = acceptHeader.trim()).startsWith(LE_MIME_TYPE)) continue;
            this.clientHasLiveEditInstalled = true;
            for (String subType : subTypes = acceptHeader.split(";")) {
                int equalQuoteIndex = subType.indexOf("=\"");
                String valueSubType = subType;
                if (equalQuoteIndex >= 0 && subType.length() > equalQuoteIndex + 3) {
                    valueSubType = subType.substring(equalQuoteIndex + 2, subType.length() - 1);
                }
                this.nxLiveEditMimeTypes.add(valueSubType.replace("!", "/"));
            }
        }
    }
}

