/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.demo.customizer;

import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.model.portal.command.render.RenderPageCommand;
import org.jboss.portal.core.theme.PageRendition;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.theming.IAttributesBundle;
import org.osivia.portal.api.urls.IPortalUrlFactory;

public class ApplicationsAttributesBundle
implements IAttributesBundle {
    private static final String APP_ATTRIBUTE_NAME = "osivia.sso.applications";
    private static final String HELP_ATTRIBUTE_NAME = "osivia.toolbar.helpURL";
    private static final String SEARCHINDIRECTORY_ATTRIBUTE_NAME = "osivia.search.directoryURL";
    private static final String NUXEO_LOGOUT = NuxeoConnectionProperties.getPublicBaseUri().toString().concat("/logout");
    private static final String CAS_LOGOUT = System.getProperty("cas.logout");
    private List<String> applications = new ArrayList();
    private static ApplicationsAttributesBundle instance;
    private final Set<String> names;
    private final IPortalUrlFactory portalURLFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");

    private ApplicationsAttributesBundle() {
        this.applications.add(NUXEO_LOGOUT);
        this.applications.add(CAS_LOGOUT);
        this.names = new TreeSet();
        this.names.add(APP_ATTRIBUTE_NAME);
    }

    public static ApplicationsAttributesBundle getInstance() {
        if (instance == null) {
            instance = new ApplicationsAttributesBundle();
        }
        return instance;
    }

    public void fill(RenderPageCommand renderPageCommand, PageRendition pageRendition, Map<String, Object> attributes) throws ControllerException {
        attributes.put(APP_ATTRIBUTE_NAME, this.applications);
        ControllerContext controllerContext = renderPageCommand.getControllerContext();
        PortalControllerContext portalControllerContext = new PortalControllerContext((Object)controllerContext);
        if (System.getProperty(HELP_ATTRIBUTE_NAME) != null) {
            String helpURL = this.portalURLFactory.getCMSUrl(portalControllerContext, null, System.getProperty(HELP_ATTRIBUTE_NAME), null, null, null, null, null, null, null);
            attributes.put(HELP_ATTRIBUTE_NAME, helpURL);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osivia.title", "Annuaire");
        properties.put("osivia.hideTitle", "1");
        HashMap parameters = new HashMap();
        String directoryUrl = null;
        try {
            directoryUrl = this.portalURLFactory.getStartPageUrl(portalControllerContext, null, "/default/templates/Annuaire", properties, parameters);
        }
        catch (PortalException portalException) {
            // empty catch block
        }
        attributes.put(SEARCHINDIRECTORY_ATTRIBUTE_NAME, directoryUrl);
    }

    public Set<String> getAttributeNames() {
        return this.names;
    }
}

