/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.demo.customizer;

import java.security.Principal;
import java.util.Arrays;
import java.util.Map;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Portal;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.customization.CustomizationModuleMetadatas;
import org.osivia.portal.api.customization.ICustomizationModule;
import org.osivia.portal.api.customization.ICustomizationModulesRepository;
import org.osivia.portal.api.customization.IProjectCustomizationConfiguration;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.urls.IPortalUrlFactory;

public class ProjectCustomizerPortlet
extends GenericPortlet
implements ICustomizationModule {
    private static final String CUSTOMIZER_NAME = "osivia.demo.customizer.project.name";
    private static final String ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY = "CustomizationModulesRepository";
    private ICustomizationModulesRepository repository;
    private final CustomizationModuleMetadatas metadatas = this.generateMetadatas();
    private final IPortalUrlFactory portalURLFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");

    private CustomizationModuleMetadatas generateMetadatas() {
        CustomizationModuleMetadatas metadatas = new CustomizationModuleMetadatas();
        metadatas.setName(CUSTOMIZER_NAME);
        metadatas.setModule((ICustomizationModule)this);
        metadatas.setCustomizationIDs(Arrays.asList("osivia.project.customizer.id"));
        return metadatas;
    }

    public void init() throws PortletException {
        super.init();
        this.repository = (ICustomizationModulesRepository)this.getPortletContext().getAttribute(ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY);
        this.repository.register(this.metadatas);
    }

    public void destroy() {
        super.destroy();
        this.repository.unregister(this.metadatas);
    }

    public void customize(String customizationID, CustomizationContext context) {
        Map attributes = context.getAttributes();
        IProjectCustomizationConfiguration configuration = (IProjectCustomizationConfiguration)attributes.get("osivia.project.customizer.configuration");
        if (configuration.isBeforeInvocation() && !configuration.isAdministrator()) {
            Portal portal;
            Page page;
            HttpServletRequest request = configuration.getHttpServletRequest();
            boolean redirect = BooleanUtils.toBoolean((String)request.getParameter("redirect"));
            Principal principal = request.getUserPrincipal();
            if (!redirect && principal != null && (page = configuration.getPage()).equals((portal = page.getPortal()).getDefaultPage())) {
                try {
                    String redirectionURL = this.portalURLFactory.adaptPortalUrlToNavigation(context.getPortalControllerContext(), "/portal/auth/MonEspace");
                    configuration.setRedirectionURL(redirectionURL);
                }
                catch (PortalException portalException) {
                    // empty catch block
                }
            }
        }
    }
}

