/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.demo.testcms;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class TestCmsPortlet
extends CMSPortlet {
    private static Log logger = LogFactory.getLog(TestCmsPortlet.class);
    private static final String VIEW_JSP = "/WEB-INF/jsp/view.jsp";
    private static final String ADMIN_JSP = "/WEB-INF/jsp/admin.jsp";

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest req, RenderResponse res) throws IOException, PortletException {
        NuxeoController nuxeoCtrl = new NuxeoController((PortletRequest)req, (PortletResponse)res, this.getPortletContext());
        res.setContentType("text/html");
        PortletRequestDispatcher rd = null;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)req);
        String nuxeoPath = window.getProperty("osivia.cms.uri");
        if (nuxeoPath == null) {
            nuxeoPath = "";
        }
        req.setAttribute("nuxeoPath", (Object)nuxeoPath);
        String displayLiveVersion = window.getProperty("osivia.cms.displayLiveVersion");
        req.setAttribute("displayLiveVersion", (Object)displayLiveVersion);
        String scope = window.getProperty("osivia.cms.scope");
        req.setAttribute("scope", (Object)scope);
        req.setAttribute("nuxeoCtrl", (Object)nuxeoCtrl);
        rd = this.getPortletContext().getRequestDispatcher(ADMIN_JSP);
        rd.include(req, res);
    }

    public void processAction(ActionRequest req, ActionResponse res) throws IOException, PortletException {
        logger.debug((Object)"processAction ");
        if ("admin".equals(req.getPortletMode().toString()) && req.getParameter("modifierPrefs") != null) {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)req);
            window.setProperty("osivia.cms.uri", req.getParameter("nuxeoPath"));
            if (req.getParameter("scope") != null && req.getParameter("scope").length() > 0) {
                window.setProperty("osivia.cms.scope", req.getParameter("scope"));
            } else if (window.getProperty("osivia.cms.scope") != null) {
                window.setProperty("osivia.cms.scope", null);
            }
            if (req.getParameter("displayLiveVersion") != null && req.getParameter("displayLiveVersion").length() > 0) {
                window.setProperty("osivia.cms.displayLiveVersion", req.getParameter("displayLiveVersion"));
            } else if (window.getProperty("osivia.cms.displayLiveVersion") != null) {
                window.setProperty("osivia.cms.displayLiveVersion", null);
            }
            res.setPortletMode(PortletMode.VIEW);
            res.setWindowState(WindowState.NORMAL);
        }
        if ("admin".equals(req.getPortletMode().toString()) && req.getParameter("annuler") != null) {
            res.setPortletMode(PortletMode.VIEW);
            res.setWindowState(WindowState.NORMAL);
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        block6: {
            try {
                String note;
                response.setContentType("text/html");
                NuxeoController nuxeoCtrl = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
                PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
                String nuxeoPath = window.getProperty("osivia.cms.uri");
                if (nuxeoPath != null) {
                    Document doc = nuxeoCtrl.fetchDocument(nuxeoPath);
                    nuxeoCtrl.setCurrentDoc(doc);
                    note = doc.getProperties().getString("note:note");
                    if (note != null) {
                        note = nuxeoCtrl.transformHTMLContent(note);
                    }
                } else {
                    response.setContentType("text/html");
                    response.getWriter().print("<h2>Document non d\u00e9fini</h2>");
                    response.getWriter().close();
                    return;
                }
                request.setAttribute("note", (Object)note);
                PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(VIEW_JSP);
                dispatcher.include(request, response);
                nuxeoCtrl.insertContentMenuBarItems();
            }
            catch (NuxeoException e) {
                PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
            }
            catch (Exception e) {
                if (e instanceof PortletException) break block6;
                throw new PortletException((Throwable)e);
            }
        }
    }
}

