/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.migration.runners;

import fr.toutatice.ecm.platform.core.helper.ToutaticeOperationHelper;
import fr.toutatice.ecm.platform.core.utils.exception.ToutaticeException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.osivia.migration.runners.AbstractRunner;
import org.osivia.migration.transaction.LauncherTransactionHelper;

public class IdsRunner
extends AbstractRunner {
    private static final Log log = LogFactory.getLog(IdsRunner.class);
    private int totalDocs = 0;
    private int treatedDocs = 0;

    public IdsRunner(CoreSession session) {
        super(session);
    }

    @Override
    public void run() {
        log.debug((Object)"===== Beginning of Ids migration =====");
        long begin = System.currentTimeMillis();
        this.totalDocs = 0;
        this.treatedDocs = 0;
        String domainsQuery = "select * from Domain";
        DocumentModelList domains = this.session.query(domainsQuery);
        this.totalDocs += domains.size();
        for (DocumentModel domain : domains) {
            String id;
            if (domain.hasSchema("toutatice") && StringUtils.isBlank((String)(id = (String)((Object)domain.getPropertyValue("ttc:webid"))))) {
                this.setIdOnLiveNVersions(domain);
            }
            String livesWithEmptyIdQuery = String.format("select * from Document where ecm:ancestorId = '%s' and (ttc:webid ='' or ttc:webid is null) and %s", domain.getId(), "ecm:isProxy = 0 AND ecm:isVersion = 0 AND ecm:currentLifeCycleState != 'deleted'");
            DocumentModelList livesWithEmptyIdDocs = this.session.query(livesWithEmptyIdQuery);
            this.totalDocs += livesWithEmptyIdDocs.size();
            for (DocumentModel live : livesWithEmptyIdDocs) {
                this.setIdOnLiveNVersions(live);
            }
        }
        this.session.save();
        long duration = System.currentTimeMillis() - begin;
        log.debug((Object)"===== End of Ids migration : ".concat(String.valueOf(this.treatedDocs)).concat(" on ").concat(String.valueOf(this.totalDocs)).concat(": ").concat(String.valueOf(duration)).concat(" ms ====="));
    }

    private void setIdOnLiveNVersions(DocumentModel live) {
        if (live.hasSchema("toutatice")) {
            LauncherTransactionHelper.checkNStartTransaction();
            try {
                live = this.setId(live);
                ++this.treatedDocs;
                String id = (String)((Object)live.getPropertyValue("ttc:webid"));
                log.debug((Object)"Id ".concat(id).concat(" set on live: ").concat(live.getPathAsString()));
                List versions = this.session.getVersions(live.getRef());
                this.totalDocs += versions.size();
                for (DocumentModel version : versions) {
                    version.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
                    version.setPropertyValue("ttc:webid", (Serializable)((Object)id));
                    this.session.saveDocument(version);
                    ++this.treatedDocs;
                    log.debug((Object)" and version ".concat(version.getPathAsString()));
                }
                this.session.save();
                LauncherTransactionHelper.commitOrRollbackTransaction();
            }
            catch (Exception e) {
                LauncherTransactionHelper.setTransactionRollbackOnly();
                log.error((Object)e);
            }
        }
    }

    protected DocumentModel setId(DocumentModel doc) {
        OperationContext context = new OperationContext(this.session);
        context.setInput((Object)doc);
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("chainSource", "notRecursive");
        try {
            return (DocumentModel)ToutaticeOperationHelper.callOperation((OperationContext)context, (String)"Document.SetWebId", param);
        }
        catch (ToutaticeException e) {
            log.error((Object)"Id on document ".concat(doc.getPathAsString()).concat(" can not have be set: ").concat(e.getMessage()));
            return null;
        }
    }
}

