/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.migration.runners;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.osivia.migration.runners.AbstractRunner;
import org.osivia.migration.transaction.LauncherTransactionHelper;

public class LocalLivesRunner
extends AbstractRunner {
    private static final Log log = LogFactory.getLog(LocalLivesRunner.class);

    public LocalLivesRunner(CoreSession session) {
        super(session);
    }

    @Override
    public void run() throws ClientException {
        log.debug((Object)"===== Beginning of LocalLives migration =====");
        int totalDocs = 0;
        int treatedDocs = 0;
        LauncherTransactionHelper.checkNStartTransaction();
        try {
            DocumentModelList publishSpaces = this.getPublishSpaces(this.session);
            DocumentModelList localLives = this.getLocalLives(this.session, publishSpaces);
            for (DocumentModel localLive : localLives) {
                if (!ToutaticeDocumentHelper.isInPublishSpace((CoreSession)this.session, (DocumentModel)localLive) || localLive.isProxy() || localLive.isVersion()) continue;
                ++totalDocs;
                if (localLive.hasFacet("isLocalPublishLive") || !localLive.addFacet("isLocalPublishLive")) continue;
                this.session.saveDocument(localLive);
                ++treatedDocs;
                log.debug((Object)(localLive.getPathAsString() + " migrated"));
            }
            this.session.save();
            LauncherTransactionHelper.commitOrRollbackTransaction();
        }
        catch (Exception e) {
            LauncherTransactionHelper.setTransactionRollbackOnly();
            log.error((Object)e);
        }
        log.debug((Object)"===== End of LocalLives migration : ".concat(String.valueOf(treatedDocs)).concat(" on ").concat(String.valueOf(totalDocs)).concat(" ====="));
    }

    private DocumentModelList getPublishSpaces(CoreSession session) {
        String request = "select * from Document where %s and ecm:mixinType = 'TTCPublishSpace'";
        String query = String.format(request, "ecm:mixinType != 'HiddenInNavigation' AND ecm:isProxy = 0 AND ecm:isVersion = 0 AND ecm:currentLifeCycleState != 'deleted'");
        return session.query(query);
    }

    private DocumentModelList getLocalLives(CoreSession session, DocumentModelList publishSpaces) {
        String spaceIdsSet = this.getSpaceIdsSet(publishSpaces);
        String request = String.format("select * from Document where %s and ttc:spaceID in %s", "ecm:mixinType != 'HiddenInNavigation' AND ecm:isProxy = 0 AND ecm:isVersion = 0 AND ecm:currentLifeCycleState != 'deleted'", spaceIdsSet);
        return session.query(request);
    }

    private String getSpaceIdsSet(DocumentModelList publishSpaces) {
        StringBuffer set = new StringBuffer();
        if (!publishSpaces.isEmpty()) {
            set.append("(");
            Iterator iterator = publishSpaces.iterator();
            while (iterator.hasNext()) {
                DocumentModel publishSpace = (DocumentModel)iterator.next();
                set.append("'").append(publishSpace.getId()).append("'");
                if (!iterator.hasNext()) continue;
                set.append(",");
            }
            set.append(")");
        }
        return set.toString();
    }
}

