/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.migration.runners;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.osivia.migration.runners.AbstractRunner;
import org.osivia.migration.transaction.LauncherTransactionHelper;

public class RemoteProxiesRunner
extends AbstractRunner {
    private static Log log = LogFactory.getLog(RemoteProxiesRunner.class);

    public RemoteProxiesRunner(CoreSession session) {
        super(session);
    }

    @Override
    public void run() throws ClientException {
        log.debug((Object)"===== Beginning of Remote Proxies migration =====");
        int totalDocs = 0;
        int treatedDocs = 0;
        LauncherTransactionHelper.checkNStartTransaction();
        try {
            String rpQuery = "select * from Document where ecm:isProxy = 1 and ecm:name not like '%.proxy'";
            DocumentModelList remoteProxies = this.session.query(rpQuery);
            totalDocs = remoteProxies.size();
            for (DocumentModel remoteProxy : remoteProxies) {
                if (remoteProxy.hasFacet("isRemoteProxy")) continue;
                remoteProxy.addFacet("isRemoteProxy");
                this.session.saveDocument(remoteProxy);
                ++treatedDocs;
            }
            this.session.save();
            LauncherTransactionHelper.commitOrRollbackTransaction();
        }
        catch (Exception e) {
            LauncherTransactionHelper.setTransactionRollbackOnly();
            log.error((Object)e);
        }
        log.debug((Object)"===== End of Remote Proxies migration : ".concat(String.valueOf(treatedDocs)).concat(" on ").concat(String.valueOf(totalDocs)).concat(" ====="));
    }
}

