/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.migration.service;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;
import org.nuxeo.ecm.platform.ec.placeful.Annotation;
import org.nuxeo.ecm.platform.ec.placeful.PlacefulServiceImpl;
import org.nuxeo.ecm.platform.ec.placeful.interfaces.PlacefulService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.osivia.migration.persistence.ejb.OttcMigrations;
import org.osivia.migration.persistence.ejb.OttcProperties;
import org.osivia.migration.service.RunnerDescriptor;
import org.osivia.migration.transaction.LauncherTransactionHelper;

public class RunnerController {
    private static final Log log = LogFactory.getLog(RunnerController.class);

    private RunnerController() {
    }

    public static boolean needToMigrate(RunnerDescriptor runnerDescriptor) {
        LauncherTransactionHelper.checkNStartTransaction();
        try {
            OttcMigrations ottcMigrations;
            OttcProperties ottcProp;
            PlacefulService pfService = NotificationServiceHelper.getPlacefulServiceBean();
            try {
                ottcProp = (OttcProperties)pfService.getAnnotation(runnerDescriptor.getRunnerId(), "OttcProperties");
            }
            catch (NoResultException nre) {
                String oldVersion = Framework.getProperty((String)"ottc.old.version");
                if (StringUtils.isBlank((String)oldVersion)) {
                    log.warn((Object)"No property 'ottc.old.version' is defined in nuxeo.conf: migration ".concat(runnerDescriptor.getRunnerId().concat(" will not be done")));
                    return false;
                }
                ottcProp = new OttcProperties(runnerDescriptor.getRunnerId(), oldVersion);
                pfService.setAnnotation((Annotation)ottcProp);
            }
            try {
                ottcMigrations = (OttcMigrations)pfService.getAnnotation(runnerDescriptor.getRunnerId(), "OttcMigrations");
            }
            catch (NoResultException nre) {
                ottcMigrations = new OttcMigrations(runnerDescriptor.getRunnerId(), runnerDescriptor.getMigrationVersion());
                pfService.setAnnotation((Annotation)ottcMigrations);
            }
            LauncherTransactionHelper.commitOrRollbackTransaction();
            return ottcProp.getCurrentVersion().compareTo(ottcMigrations.getMigrationVersion()) < 0;
        }
        catch (Exception e) {
            LauncherTransactionHelper.setTransactionRollbackOnly();
            log.error((Object)e);
            return false;
        }
    }

    protected static void storeCurrentOttcVersion(RunnerDescriptor runnerDescriptor) {
        LauncherTransactionHelper.checkNStartTransaction();
        boolean isTx = TransactionHelper.isTransactionActive();
        if (!isTx) {
            isTx = TransactionHelper.startTransaction();
        }
        try {
            String currentVersion = Framework.getProperty((String)"ottc.version");
            if (StringUtils.isBlank((String)currentVersion)) {
                log.warn((Object)"No property 'ottc.version' is defined in nuxeo.conf: you must update manually ottcproperties table");
            }
            PlacefulService pfService = NotificationServiceHelper.getPlacefulServiceBean();
            EntityManager entityManager = ((PlacefulServiceImpl)pfService).getOrCreatePersistenceProvider().acquireEntityManagerWithActiveTransaction();
            OttcProperties notUpdatedEntity = (OttcProperties)((Object)entityManager.getReference(OttcProperties.class, (Object)runnerDescriptor.getRunnerId()));
            entityManager.remove((Object)notUpdatedEntity);
            if (isTx) {
                LauncherTransactionHelper.commitOrRollbackTransaction();
            }
            if (!TransactionHelper.isTransactionActive()) {
                LauncherTransactionHelper.checkNStartTransaction();
                if (!TransactionHelper.isTransactionActive()) {
                    isTx = TransactionHelper.startTransaction();
                }
            }
            pfService.setAnnotation((Annotation)new OttcProperties(runnerDescriptor.getRunnerId(), currentVersion));
            if (isTx) {
                LauncherTransactionHelper.commitOrRollbackTransaction();
            }
        }
        catch (Exception e) {
            if (isTx) {
                LauncherTransactionHelper.setTransactionRollbackOnly();
            }
            log.error((Object)e);
        }
    }
}

