/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.migration.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.login.LoginContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.osivia.migration.runners.AbstractRunner;
import org.osivia.migration.service.RunnerController;
import org.osivia.migration.service.RunnerDescriptor;

public class RunnerLauncherService
extends DefaultComponent {
    private static final Log log = LogFactory.getLog(RunnerLauncherService.class);
    private static final String RUNNERS_PT_EXT = "runners";
    private static final String SILENT_METHOD = "silentRun";
    private static final List<RunnerDescriptor> runnersDescriptors = new ArrayList<RunnerDescriptor>();

    public int getApplicationStartedOrder() {
        return 9999;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (RUNNERS_PT_EXT.equals(extensionPoint)) {
            RunnerDescriptor runnerDescriptor = (RunnerDescriptor)contribution;
            runnersDescriptors.add(runnerDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationStarted(ComponentContext context) throws Exception {
        for (RunnerDescriptor runnerDescriptor : runnersDescriptors) {
            if (!RunnerController.needToMigrate(runnerDescriptor)) continue;
            LoginContext loginContext = Framework.loginAs((String)"system");
            CoreSession session = CoreInstance.openCoreSession((String)"default");
            try {
                String runnerClass = runnerDescriptor.getClazz();
                Class<?> runner = Class.forName(runnerClass);
                Method silentRunMethod = this.getSilentRunMethod(runner.getMethods());
                if (silentRunMethod != null) {
                    Class[] constructorParams = new Class[]{CoreSession.class};
                    Constructor<?> constructor = runner.getDeclaredConstructor(constructorParams);
                    Object runnerInstance = constructor.newInstance(session);
                    Object[] params = new Object[]{Boolean.TRUE, AbstractRunner.FILTERED_SERVICES_LIST};
                    silentRunMethod.invoke(runnerInstance, params);
                    RunnerController.storeCurrentOttcVersion(runnerDescriptor);
                    continue;
                }
                log.error((Object)("No 'silentRun' method for " + runner.getName()));
            }
            finally {
                session.close();
                loginContext.logout();
            }
        }
    }

    private Method getSilentRunMethod(Method[] methods) {
        Method srMethod = null;
        List<Method> methodsList = Arrays.asList(methods);
        Iterator<Method> iterator = methodsList.iterator();
        boolean found = false;
        while (iterator.hasNext() && !found) {
            Class<?>[] parameterTypes;
            Method method = iterator.next();
            String nameMethod = method.getName();
            if (!SILENT_METHOD.equals(nameMethod) || (parameterTypes = method.getParameterTypes()) == null || parameterTypes.length != 2) continue;
            srMethod = method;
            found = true;
        }
        return srMethod;
    }
}

